/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streams.twitter.pojo;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.streams.twitter.pojo.TargetObject;
import org.joda.time.DateTime;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"created_at", "event_type", "source", "target", "target_object"})
public class UserstreamEvent
implements Serializable {
    @JsonProperty(value="created_at")
    private DateTime createdAt;
    @JsonProperty(value="event_type")
    private EventType eventType;
    @JsonProperty(value="source")
    private String source;
    @JsonProperty(value="target")
    private String target;
    @JsonProperty(value="target_object")
    private TargetObject targetObject;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    @JsonProperty(value="created_at")
    public DateTime getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="created_at")
    public void setCreatedAt(DateTime createdAt) {
        this.createdAt = createdAt;
    }

    public UserstreamEvent withCreatedAt(DateTime createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    @JsonProperty(value="event_type")
    public EventType getEventType() {
        return this.eventType;
    }

    @JsonProperty(value="event_type")
    public void setEventType(EventType eventType) {
        this.eventType = eventType;
    }

    public UserstreamEvent withEventType(EventType eventType) {
        this.eventType = eventType;
        return this;
    }

    @JsonProperty(value="source")
    public String getSource() {
        return this.source;
    }

    @JsonProperty(value="source")
    public void setSource(String source) {
        this.source = source;
    }

    public UserstreamEvent withSource(String source) {
        this.source = source;
        return this;
    }

    @JsonProperty(value="target")
    public String getTarget() {
        return this.target;
    }

    @JsonProperty(value="target")
    public void setTarget(String target) {
        this.target = target;
    }

    public UserstreamEvent withTarget(String target) {
        this.target = target;
        return this;
    }

    @JsonProperty(value="target_object")
    public TargetObject getTargetObject() {
        return this.targetObject;
    }

    @JsonProperty(value="target_object")
    public void setTargetObject(TargetObject targetObject) {
        this.targetObject = targetObject;
    }

    public UserstreamEvent withTargetObject(TargetObject targetObject) {
        this.targetObject = targetObject;
        return this;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public UserstreamEvent withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.createdAt).append((Object)this.eventType).append((Object)this.source).append((Object)this.target).append((Object)this.targetObject).append(this.additionalProperties).toHashCode();
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof UserstreamEvent)) {
            return false;
        }
        UserstreamEvent rhs = (UserstreamEvent)other;
        return new EqualsBuilder().append((Object)this.createdAt, (Object)rhs.createdAt).append((Object)this.eventType, (Object)rhs.eventType).append((Object)this.source, (Object)rhs.source).append((Object)this.target, (Object)rhs.target).append((Object)this.targetObject, (Object)rhs.targetObject).append(this.additionalProperties, rhs.additionalProperties).isEquals();
    }

    public static enum EventType {
        ACCESS_REVOKED("access_revoked"),
        BLOCK("block"),
        UNBLOCK("unblock"),
        FAVORITE("favorite"),
        UNFAVORITE("unfavorite"),
        FOLLOW("follow"),
        UNFOLLOW("unfollow"),
        LIST_CREATED("list_created"),
        LIST_DESTROYED("list_destroyed"),
        LIST_UPDATED("list_updated"),
        LIST_MEMBER_ADDED("list_member_added"),
        LIST_MEMBER_REMOVED("list_member_removed"),
        LIST_USER_SUBSCRIBED("list_user_subscribed"),
        LIST_USER_UNSUBSCRIBED("list_user_unsubscribed"),
        USER_UPDATE("user_update");

        private final String value;
        private static Map<String, EventType> constants;

        private EventType(String value) {
            this.value = value;
        }

        @JsonValue
        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static EventType fromValue(String value) {
            EventType constant = constants.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            constants = new HashMap<String, EventType>();
            for (EventType c : EventType.values()) {
                constants.put(c.value, c);
            }
        }
    }
}

