/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streams.twitter.converter.util;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.math.DoubleMath;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.streams.exceptions.ActivityConversionException;
import org.apache.streams.jackson.StreamsJacksonMapper;
import org.apache.streams.pojo.extensions.ExtensionUtil;
import org.apache.streams.pojo.json.Activity;
import org.apache.streams.pojo.json.ActivityObject;
import org.apache.streams.pojo.json.Actor;
import org.apache.streams.pojo.json.Image;
import org.apache.streams.pojo.json.Provider;
import org.apache.streams.twitter.Url;
import org.apache.streams.twitter.pojo.Delete;
import org.apache.streams.twitter.pojo.Entities;
import org.apache.streams.twitter.pojo.Hashtag;
import org.apache.streams.twitter.pojo.Place;
import org.apache.streams.twitter.pojo.Retweet;
import org.apache.streams.twitter.pojo.Tweet;
import org.apache.streams.twitter.pojo.User;
import org.apache.streams.twitter.pojo.UserMentions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TwitterActivityUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(TwitterActivityUtil.class);

    public static void updateActivity(Tweet tweet, Activity activity) throws ActivityConversionException {
        StreamsJacksonMapper mapper = StreamsJacksonMapper.getInstance();
        activity.setActor(TwitterActivityUtil.buildActor(tweet));
        activity.setId(TwitterActivityUtil.formatId(activity.getVerb(), (String)Optional.fromNullable((Object)tweet.getIdStr()).or(Optional.of((Object)tweet.getId().toString())).orNull()));
        if (tweet instanceof Retweet) {
            TwitterActivityUtil.updateActivityContent(activity, ((Retweet)tweet).getRetweetedStatus(), "share");
        } else {
            TwitterActivityUtil.updateActivityContent(activity, tweet, "post");
        }
        if (Strings.isNullOrEmpty((String)activity.getId())) {
            throw new ActivityConversionException("Unable to determine activity id");
        }
        try {
            activity.setPublished(tweet.getCreatedAt());
        }
        catch (Exception e) {
            throw new ActivityConversionException("Unable to determine publishedDate", (Throwable)e);
        }
        activity.setTarget(TwitterActivityUtil.buildTarget(tweet));
        activity.setProvider(TwitterActivityUtil.getProvider());
        activity.setUrl(String.format("http://twitter.com/%s/%s/%s", tweet.getUser().getScreenName(), "/status/", tweet.getIdStr()));
        TwitterActivityUtil.addTwitterExtension(activity, (ObjectNode)mapper.convertValue((Object)tweet, ObjectNode.class));
    }

    public static void updateActivity(User user, Activity activity) {
        activity.setActor(TwitterActivityUtil.buildActor(user));
        activity.setId(null);
        activity.setVerb(null);
    }

    public static void updateActivity(Delete delete, Activity activity) throws ActivityConversionException {
        activity.setActor(TwitterActivityUtil.buildActor(delete));
        activity.setVerb("delete");
        activity.setObject(TwitterActivityUtil.buildActivityObject(delete));
        activity.setId(TwitterActivityUtil.formatId(activity.getVerb(), delete.getDelete().getStatus().getIdStr()));
        if (Strings.isNullOrEmpty((String)activity.getId())) {
            throw new ActivityConversionException("Unable to determine activity id");
        }
        activity.setProvider(TwitterActivityUtil.getProvider());
        TwitterActivityUtil.addTwitterExtension(activity, (ObjectNode)StreamsJacksonMapper.getInstance().convertValue((Object)delete, ObjectNode.class));
    }

    public static Actor buildActor(Delete delete) {
        Actor actor = new Actor();
        actor.setId(TwitterActivityUtil.formatId(delete.getDelete().getStatus().getUserIdStr()));
        actor.setObjectType("page");
        return actor;
    }

    public static ActivityObject buildActivityObject(Delete delete) {
        ActivityObject actObj = new ActivityObject();
        actObj.setId(TwitterActivityUtil.formatId(delete.getDelete().getStatus().getIdStr()));
        actObj.setObjectType("tweet");
        return actObj;
    }

    public static void updateActivityContent(Activity activity, Tweet tweet, String verb) {
        activity.setVerb(verb);
        activity.setTitle("");
        if (tweet != null) {
            activity.setObject(TwitterActivityUtil.buildActivityObject(tweet));
            activity.setLinks(TwitterActivityUtil.getLinks(tweet));
            activity.setContent(tweet.getText());
            TwitterActivityUtil.addLocationExtension(activity, tweet);
            TwitterActivityUtil.addTwitterExtensions(activity, tweet);
        }
    }

    public static ActivityObject buildActivityObject(Tweet tweet) {
        ActivityObject actObj = new ActivityObject();
        String id = (String)Optional.fromNullable((Object)tweet.getIdStr()).or(Optional.of((Object)tweet.getId().toString())).orNull();
        if (id != null) {
            actObj.setId(id);
        }
        actObj.setObjectType("post");
        actObj.setContent(tweet.getText());
        return actObj;
    }

    public static Actor buildActor(Tweet tweet) {
        Actor actor = new Actor();
        User user = tweet.getUser();
        return TwitterActivityUtil.buildActor(user);
    }

    public static Actor buildActor(User user) {
        Actor actor = new Actor();
        actor.setId(TwitterActivityUtil.formatId((String)Optional.fromNullable((Object)user.getIdStr()).or(Optional.of((Object)user.getId().toString())).orNull()));
        actor.setObjectType("page");
        actor.setDisplayName(user.getName());
        actor.setAdditionalProperty("handle", (Object)user.getScreenName());
        actor.setSummary(user.getDescription());
        if (user.getUrl() != null) {
            actor.setUrl(user.getUrl());
        }
        HashMap<String, Object> extensions = new HashMap<String, Object>();
        extensions.put("location", user.getLocation());
        extensions.put("posts", user.getStatusesCount());
        extensions.put("favorites", user.getFavouritesCount());
        extensions.put("followers", user.getFollowersCount());
        Image profileImage = new Image();
        profileImage.setUrl(user.getProfileImageUrlHttps());
        actor.setImage(profileImage);
        extensions.put("screenName", user.getScreenName());
        actor.setAdditionalProperty("extensions", extensions);
        return actor;
    }

    public static List<String> getLinks(Tweet tweet) {
        ArrayList<String> links = new ArrayList<String>();
        if (tweet.getEntities().getUrls() != null) {
            for (Url url : tweet.getEntities().getUrls()) {
                links.add(url.getExpandedUrl());
            }
        } else {
            LOGGER.debug("  0 links");
        }
        return links;
    }

    public static ActivityObject buildTarget(Tweet tweet) {
        return null;
    }

    public static void addLocationExtension(Activity activity, Tweet tweet) {
        Map extensions = ExtensionUtil.getInstance().ensureExtensions(activity);
        HashMap<String, Object> location = new HashMap<String, Object>();
        location.put("id", TwitterActivityUtil.formatId((String)Optional.fromNullable((Object)tweet.getIdStr()).or(Optional.of((Object)tweet.getId().toString())).orNull()));
        location.put("coordinates", TwitterActivityUtil.boundingBoxCenter(tweet.getPlace()));
        extensions.put("location", location);
    }

    public static Provider getProvider() {
        Provider provider = new Provider();
        provider.setId("id:providers:twitter");
        provider.setObjectType("application");
        provider.setDisplayName("Twitter");
        return provider;
    }

    public static void addTwitterExtension(Activity activity, ObjectNode event) {
        Map extensions = ExtensionUtil.getInstance().ensureExtensions(activity);
        extensions.put("twitter", event);
    }

    public static String formatId(String ... idparts) {
        return Joiner.on((String)":").join((Iterable)Lists.asList((Object)"id:twitter", (Object[])idparts));
    }

    public static void addTwitterExtensions(Activity activity, Tweet tweet) {
        Map extensions = ExtensionUtil.getInstance().ensureExtensions(activity);
        ArrayList<String> hashtags = new ArrayList<String>();
        for (Hashtag hashtag : tweet.getEntities().getHashtags()) {
            hashtags.add(hashtag.getText());
        }
        extensions.put("hashtags", hashtags);
        HashMap<String, Object> likes = new HashMap<String, Object>();
        likes.put("perspectival", tweet.getFavorited());
        likes.put("count", tweet.getAdditionalProperties().get("favorite_count"));
        extensions.put("likes", likes);
        HashMap<String, Comparable<Boolean>> rebroadcasts = new HashMap<String, Comparable<Boolean>>();
        rebroadcasts.put("perspectival", tweet.getRetweeted());
        rebroadcasts.put("count", tweet.getRetweetCount());
        extensions.put("rebroadcasts", rebroadcasts);
        ArrayList userMentions = new ArrayList();
        Entities entities = tweet.getEntities();
        for (UserMentions user : entities.getUserMentions()) {
            HashMap<String, String> actor = new HashMap<String, String>();
            actor.put("id", "id:twitter:" + user.getIdStr());
            actor.put("displayName", user.getName());
            actor.put("handle", user.getScreenName());
            userMentions.add(actor);
        }
        extensions.put("user_mentions", userMentions);
        extensions.put("keywords", tweet.getText());
    }

    public static List<Double> boundingBoxCenter(Place place) {
        if (place == null) {
            return new ArrayList<Double>();
        }
        if (place.getBoundingBox() == null) {
            return new ArrayList<Double>();
        }
        if (place.getBoundingBox().getCoordinates().size() != 1) {
            return new ArrayList<Double>();
        }
        if (place.getBoundingBox().getCoordinates().get(0).size() != 4) {
            return new ArrayList<Double>();
        }
        ArrayList<Double> lats = new ArrayList<Double>();
        ArrayList<Double> lons = new ArrayList<Double>();
        for (List<Double> point : place.getBoundingBox().getCoordinates().get(0)) {
            lats.add(point.get(0));
            lons.add(point.get(1));
        }
        ArrayList<Double> result = new ArrayList<Double>();
        result.add(DoubleMath.mean(lats));
        result.add(DoubleMath.mean(lons));
        return result;
    }
}

