/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streams.twitter.converter;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.streams.data.DocumentClassifier;
import org.apache.streams.jackson.StreamsJacksonMapper;
import org.apache.streams.twitter.pojo.Delete;
import org.apache.streams.twitter.pojo.Follow;
import org.apache.streams.twitter.pojo.FriendList;
import org.apache.streams.twitter.pojo.Retweet;
import org.apache.streams.twitter.pojo.Tweet;
import org.apache.streams.twitter.pojo.User;
import org.apache.streams.twitter.pojo.UserstreamEvent;

public class TwitterDocumentClassifier
implements DocumentClassifier {
    public List<Class> detectClasses(Object document) {
        ObjectNode objectNode;
        Preconditions.checkNotNull((Object)document);
        StreamsJacksonMapper mapper = StreamsJacksonMapper.getInstance((List)Lists.newArrayList((Object[])new String[]{"EEE MMM dd HH:mm:ss Z yyyy"}));
        try {
            objectNode = document instanceof String ? (ObjectNode)mapper.readValue((String)document, ObjectNode.class) : (document instanceof ObjectNode ? (ObjectNode)document : (ObjectNode)mapper.convertValue(document, ObjectNode.class));
        }
        catch (IOException e) {
            return new ArrayList<Class>();
        }
        ArrayList<Class> classList = new ArrayList<Class>();
        if (objectNode.findValue("retweeted_status") != null && objectNode.get("retweeted_status") != null) {
            classList.add(Retweet.class);
        } else if (objectNode.findValue("delete") != null) {
            classList.add(Delete.class);
        } else if (objectNode.findValue("friends") != null || objectNode.findValue("friends_str") != null) {
            classList.add(FriendList.class);
        } else if (objectNode.findValue("target_object") != null) {
            classList.add(UserstreamEvent.class);
        } else if (objectNode.findValue("follower") != null && objectNode.findValue("followee") != null) {
            classList.add(Follow.class);
        } else if (objectNode.findValue("location") != null && objectNode.findValue("user") == null) {
            classList.add(User.class);
        } else {
            classList.add(Tweet.class);
        }
        return classList;
    }
}

