/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streams.twitter.converter;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.io.IOException;
import org.apache.streams.data.util.RFC3339Utils;
import org.apache.streams.jackson.StreamsJacksonMapper;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

@Deprecated
public class StreamsTwitterMapper
extends StreamsJacksonMapper {
    public static final String TWITTER_FORMAT = "EEE MMM dd HH:mm:ss Z yyyy";
    public static final DateTimeFormatter TWITTER_FORMATTER = DateTimeFormat.forPattern((String)"EEE MMM dd HH:mm:ss Z yyyy");
    private static final StreamsTwitterMapper INSTANCE = new StreamsTwitterMapper();

    public static Long getMillis(String dateTime) {
        try {
            return TWITTER_FORMATTER.parseMillis(dateTime);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static StreamsTwitterMapper getInstance() {
        return INSTANCE;
    }

    public StreamsTwitterMapper() {
        this.registerModule((Module)new SimpleModule(){
            {
                this.addDeserializer(DateTime.class, (JsonDeserializer)new StdDeserializer<DateTime>(DateTime.class){

                    public DateTime deserialize(JsonParser jpar, DeserializationContext context) throws IOException, JsonProcessingException {
                        DateTime result = null;
                        try {
                            result = TWITTER_FORMATTER.parseDateTime(jpar.getValueAsString());
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        try {
                            RFC3339Utils.getInstance();
                            result = RFC3339Utils.parseToUTC((String)jpar.getValueAsString());
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        return result;
                    }
                });
            }
        });
    }
}

