/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streams.jackson;

import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.streams.jackson.StreamsDateTimeDeserializer;
import org.apache.streams.jackson.StreamsDateTimeFormat;
import org.apache.streams.jackson.StreamsDateTimeSerializer;
import org.apache.streams.jackson.StreamsPeriodDeserializer;
import org.apache.streams.jackson.StreamsPeriodSerializer;
import org.joda.time.DateTime;
import org.joda.time.Period;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.reflections.scanners.SubTypesScanner;
import org.reflections.util.ClasspathHelper;
import org.reflections.util.ConfigurationBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamsJacksonModule
extends SimpleModule {
    private static final Logger LOGGER = LoggerFactory.getLogger(StreamsJacksonModule.class);

    public StreamsJacksonModule() {
        Reflections reflections = new Reflections((Configuration)new ConfigurationBuilder().setUrls(ClasspathHelper.forPackage((String)"org.apache.streams.jackson", (ClassLoader[])new ClassLoader[0])).setScanners(new Scanner[]{new SubTypesScanner()}));
        Set dateTimeFormatClasses = reflections.getSubTypesOf(StreamsDateTimeFormat.class);
        ArrayList<String> dateTimeFormats = new ArrayList<String>();
        for (Class dateTimeFormatClass : dateTimeFormatClasses) {
            try {
                dateTimeFormats.add(((StreamsDateTimeFormat)dateTimeFormatClass.newInstance()).getFormat());
            }
            catch (Exception e) {
                LOGGER.warn("Exception getting format from " + dateTimeFormatClass);
            }
        }
        this.addSerializer(DateTime.class, (JsonSerializer)new StreamsDateTimeSerializer(DateTime.class));
        this.addDeserializer(DateTime.class, (JsonDeserializer)new StreamsDateTimeDeserializer(DateTime.class, dateTimeFormats));
        this.addSerializer(Period.class, (JsonSerializer)new StreamsPeriodSerializer(Period.class));
        this.addDeserializer(Period.class, (JsonDeserializer)new StreamsPeriodDeserializer(Period.class));
    }

    public StreamsJacksonModule(List<String> formats) {
        this.addSerializer(DateTime.class, (JsonSerializer)new StreamsDateTimeSerializer(DateTime.class));
        this.addDeserializer(DateTime.class, (JsonDeserializer)new StreamsDateTimeDeserializer(DateTime.class, formats));
        this.addSerializer(Period.class, (JsonSerializer)new StreamsPeriodSerializer(Period.class));
        this.addDeserializer(Period.class, (JsonDeserializer)new StreamsPeriodDeserializer(Period.class));
    }
}

