/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streams.jackson;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import org.apache.streams.data.util.RFC3339Utils;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamsDateTimeDeserializer
extends StdDeserializer<DateTime>
implements Serializable {
    List<DateTimeFormatter> formatters = Lists.newArrayList();
    private static final Logger LOGGER = LoggerFactory.getLogger(StreamsDateTimeDeserializer.class);

    protected StreamsDateTimeDeserializer(Class<DateTime> dateTimeClass) {
        super(dateTimeClass);
    }

    protected StreamsDateTimeDeserializer(Class<DateTime> dateTimeClass, List<String> formats) {
        super(dateTimeClass);
        for (String format : formats) {
            try {
                this.formatters.add(DateTimeFormat.forPattern((String)format));
            }
            catch (Exception e) {
                LOGGER.warn("Exception parsing format " + format);
            }
        }
    }

    public DateTime deserialize(JsonParser jpar, DeserializationContext context) throws IOException {
        DateTime result = RFC3339Utils.parseToUTC(jpar.getValueAsString());
        Iterator<DateTimeFormatter> iterator = this.formatters.iterator();
        while (result == null && iterator.hasNext()) {
            DateTimeFormatter formatter = iterator.next();
            result = formatter.parseDateTime(jpar.getValueAsString());
        }
        return result;
    }
}

