/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streams.data.util;

import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.DateTimeFormatterBuilder;
import org.joda.time.format.DateTimeParser;

public class RFC3339Utils {
    private static final RFC3339Utils INSTANCE = new RFC3339Utils();
    private static final String BASE = "^[0-9]{4}\\-[0-9]{2}\\-[0-9]{2}T[0-9]{2}:[0-9]{2}:[0-9]{2}";
    private static final String TZ = "[+-][0-9]{2}:?[0-9]{2}$";
    private static final String SUB_SECOND = "\\.([0-9]*)";
    private static final String UTC = "Z$";
    private static final Pattern MILLIS = Pattern.compile("^[0-9]*$");
    private static final Pattern UTC_STANDARD = Pattern.compile("^[0-9]{4}\\-[0-9]{2}\\-[0-9]{2}T[0-9]{2}:[0-9]{2}:[0-9]{2}Z$");
    private static final Pattern UTC_SUB_SECOND = Pattern.compile("^[0-9]{4}\\-[0-9]{2}\\-[0-9]{2}T[0-9]{2}:[0-9]{2}:[0-9]{2}\\.([0-9]*)Z$");
    private static final Pattern LOCAL_STANDARD = Pattern.compile("^[0-9]{4}\\-[0-9]{2}\\-[0-9]{2}T[0-9]{2}:[0-9]{2}:[0-9]{2}[+-][0-9]{2}:?[0-9]{2}$");
    private static final Pattern LOCAL_SUB_SECOND = Pattern.compile("^[0-9]{4}\\-[0-9]{2}\\-[0-9]{2}T[0-9]{2}:[0-9]{2}:[0-9]{2}\\.([0-9]*)[+-][0-9]{2}:?[0-9]{2}$");
    private static final String BASE_FMT = "yyyy-MM-dd'T'HH:mm:ss";
    public static final DateTimeFormatter UTC_STANDARD_FMT = DateTimeFormat.forPattern((String)"yyyy-MM-dd'T'HH:mm:ss'Z'").withZoneUTC();
    public static final DateTimeFormatter UTC_SUB_SECOND_FMT = DateTimeFormat.forPattern((String)"yyyy-MM-dd'T'HH:mm:ss.SSS'Z'").withZoneUTC();
    public static final DateTimeFormatter LOCAL_STANDARD_FMT = DateTimeFormat.forPattern((String)"yyyy-MM-dd'T'HH:mm:ssZ").withZoneUTC();
    public static final DateTimeFormatter LOCAL_SUB_SECOND_FMT = DateTimeFormat.forPattern((String)"yyyy-MM-dd'T'HH:mm:ss.SSSZ").withZoneUTC();
    private static final DateTimeFormatter DEFAULT_FORMATTER;
    private static final DateTimeFormatter ALT_FORMATTER;

    public static RFC3339Utils getInstance() {
        return INSTANCE;
    }

    private RFC3339Utils() {
    }

    public static DateTime parseUTC(String toParse) {
        if (MILLIS.matcher(toParse).matches()) {
            return new DateTime((Object)Long.valueOf(toParse), DateTimeZone.UTC);
        }
        if (UTC_STANDARD.matcher(toParse).matches()) {
            return RFC3339Utils.parseUTC(UTC_STANDARD_FMT, toParse);
        }
        Matcher utc = UTC_SUB_SECOND.matcher(toParse);
        if (utc.matches()) {
            return RFC3339Utils.parseUTC(RFC3339Utils.getSubSecondFormat(utc.group(1), "'Z'"), toParse);
        }
        if (LOCAL_STANDARD.matcher(toParse).matches()) {
            return RFC3339Utils.parseUTC(LOCAL_STANDARD_FMT, toParse);
        }
        Matcher local = LOCAL_SUB_SECOND.matcher(toParse);
        if (local.matches()) {
            return RFC3339Utils.parseUTC(RFC3339Utils.getSubSecondFormat(local.group(1), "Z"), toParse);
        }
        throw new IllegalArgumentException(String.format("Failed to parse date %s. Ensure format is RFC3339 Compliant", toParse));
    }

    public static String format(DateTime toFormat) {
        return UTC_SUB_SECOND_FMT.print(toFormat.getMillis());
    }

    public static String format(DateTime toFormat, TimeZone tz) {
        return LOCAL_SUB_SECOND_FMT.withZone(DateTimeZone.forTimeZone((TimeZone)tz)).print(toFormat.getMillis());
    }

    public static DateTime parseToUTC(String dateString) {
        if (MILLIS.matcher(dateString).find()) {
            return new DateTime(Long.parseLong(dateString));
        }
        try {
            return DEFAULT_FORMATTER.parseDateTime(dateString);
        }
        catch (Exception e) {
            return ALT_FORMATTER.parseDateTime(dateString);
        }
    }

    public static String format(String dateString) {
        return RFC3339Utils.format(RFC3339Utils.parseToUTC(dateString));
    }

    private static DateTime parseUTC(DateTimeFormatter formatter, String toParse) {
        return formatter.parseDateTime(toParse);
    }

    private static DateTimeFormatter getSubSecondFormat(String sub, String suffix) {
        DateTimeFormatter result;
        if (sub.length() == 3) {
            result = suffix.equals("Z") ? LOCAL_SUB_SECOND_FMT : UTC_SUB_SECOND_FMT;
        } else {
            StringBuilder pattern = new StringBuilder();
            pattern.append(BASE_FMT);
            pattern.append(".");
            for (int i = 0; i < sub.length(); ++i) {
                pattern.append("S");
            }
            pattern.append(suffix);
            result = DateTimeFormat.forPattern((String)pattern.toString()).withZoneUTC();
        }
        return result;
    }

    static {
        DateTimeParser[] parsers = new DateTimeParser[]{DateTimeFormat.forPattern((String)"EEE MMM dd HH:mm:ss Z yyyy").withZoneUTC().getParser(), DateTimeFormat.forPattern((String)"EEE, dd MMM yyyy HH:mm:ss Z").getParser(), DateTimeFormat.forPattern((String)"dd MMMM yyyy HH:mm:ss").withZoneUTC().getParser(), DateTimeFormat.forPattern((String)"yyyyMMdd").withZoneUTC().getParser(), DateTimeFormat.forPattern((String)"dd-MM-yyyy").withZoneUTC().getParser(), DateTimeFormat.forPattern((String)"yyyy-MM-dd").withZoneUTC().getParser(), DateTimeFormat.forPattern((String)"yyyy/MM/dd").withZoneUTC().getParser(), DateTimeFormat.forPattern((String)"dd MMM yyyy").withZoneUTC().getParser(), DateTimeFormat.forPattern((String)"dd MMMM yyyy").withZoneUTC().getParser(), DateTimeFormat.forPattern((String)"yyyyMMddHHmm").withZoneUTC().getParser(), DateTimeFormat.forPattern((String)"yyyyMMdd HHmm").withZoneUTC().getParser(), DateTimeFormat.forPattern((String)"dd-MM-yyyy HH:mm").withZoneUTC().getParser(), DateTimeFormat.forPattern((String)"yyyy-MM-dd HH:mm").withZoneUTC().getParser(), DateTimeFormat.forPattern((String)"yyyy/MM/dd HH:mm").withZoneUTC().getParser(), DateTimeFormat.forPattern((String)"dd MMM yyyy HH:mm").withZoneUTC().getParser(), DateTimeFormat.forPattern((String)"dd MMMM yyyy HH:mm").withZoneUTC().getParser(), DateTimeFormat.forPattern((String)"yyyyMMddHHmmss").withZoneUTC().getParser(), DateTimeFormat.forPattern((String)"yyyyMMdd HHmmss").withZoneUTC().getParser(), DateTimeFormat.forPattern((String)"dd-MM-yyyy HH:mm:ss").withZoneUTC().getParser(), DateTimeFormat.forPattern((String)"yyyy-MM-dd HH:mm:ss").withZoneUTC().getParser(), DateTimeFormat.forPattern((String)"yyyy/MM/dd HH:mm:ss").withZoneUTC().getParser(), DateTimeFormat.forPattern((String)"dd MMM yyyy HH:mm:ss").withZoneUTC().getParser(), DateTimeFormat.forPattern((String)"HH:mm:ss yyyy/MM/dd").withZoneUTC().getParser(), DateTimeFormat.forPattern((String)"HH:mm:ss MM/dd/yyyy").withZoneUTC().getParser(), DateTimeFormat.forPattern((String)"HH:mm:ss yyyy-MM-dd").withZoneUTC().getParser(), DateTimeFormat.forPattern((String)"HH:mm:ss MM-dd-yyyy").withZoneUTC().getParser(), DateTimeFormat.forPattern((String)"dd/MM/yyyy HH:mm:ss").withZoneUTC().getParser(), DateTimeFormat.forPattern((String)"dd/MM/yyyy HH:mm").withZoneUTC().getParser(), DateTimeFormat.forPattern((String)"dd/MM/yyyy").withZoneUTC().getParser(), UTC_STANDARD_FMT.getParser(), UTC_SUB_SECOND_FMT.getParser(), LOCAL_STANDARD_FMT.getParser(), LOCAL_SUB_SECOND_FMT.getParser()};
        DateTimeFormatterBuilder builder = new DateTimeFormatterBuilder();
        builder.append(null, parsers);
        DEFAULT_FORMATTER = builder.toFormatter().withZoneUTC();
        DateTimeParser[] altParsers = new DateTimeParser[]{DateTimeFormat.forPattern((String)"MM-dd-yyyy HH:mm:ss").withZoneUTC().getParser(), DateTimeFormat.forPattern((String)"MM/dd/yyyy HH:mm:ss").withZoneUTC().getParser(), DateTimeFormat.forPattern((String)"MM/dd/yyyy HH:mm").withZoneUTC().getParser(), DateTimeFormat.forPattern((String)"MM/dd/yyyy").withZoneUTC().getParser()};
        builder = new DateTimeFormatterBuilder();
        builder.append(null, altParsers);
        ALT_FORMATTER = builder.toFormatter().withZoneUTC();
    }
}

