/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streams.data.util;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import org.apache.streams.jackson.StreamsJacksonMapper;

public class JsonUtil {
    private static ObjectMapper mapper = StreamsJacksonMapper.getInstance();
    private static JsonFactory factory = mapper.getFactory();

    private JsonUtil() {
    }

    public static JsonNode jsonToJsonNode(String json) {
        JsonNode node;
        try {
            JsonParser jp = factory.createJsonParser(json);
            node = (JsonNode)mapper.readTree(jp);
        }
        catch (IOException e) {
            throw new RuntimeException("IO exception while reading JSON", e);
        }
        return node;
    }

    public static String jsonNodeToJson(JsonNode node) {
        try {
            return mapper.writeValueAsString((Object)node);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("IO exception while writing JSON", e);
        }
    }

    public static <T> T jsonToObject(String json, Class<T> clazz) {
        try {
            return (T)mapper.readValue(json, clazz);
        }
        catch (IOException e) {
            throw new RuntimeException("Could not map to object");
        }
    }

    public static <T> T jsonNodeToObject(JsonNode node, Class<T> clazz) {
        return (T)mapper.convertValue((Object)node, clazz);
    }

    public static <T> JsonNode objectToJsonNode(T obj) {
        return mapper.valueToTree(obj);
    }

    public static <T> List<T> jsoNodeToList(JsonNode node, Class<T> clazz) {
        return (List)mapper.convertValue((Object)node, new TypeReference<List<T>>(){});
    }

    public static <T> String objectToJson(T object) {
        try {
            return mapper.writeValueAsString(object);
        }
        catch (IOException e) {
            throw new RuntimeException("Could not map to object");
        }
    }

    public static <T> T getObjFromFile(String filePath, Class<T> clazz) {
        return JsonUtil.jsonNodeToObject(JsonUtil.getFromFile(filePath), clazz);
    }

    public static JsonNode getFromFile(String filePath) {
        JsonFactory factory = mapper.getFactory();
        JsonNode node = null;
        try {
            InputStream stream = JsonUtil.getStreamForLocation(filePath);
            JsonParser jp = factory.createParser(stream);
            node = (JsonNode)mapper.readTree(jp);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return node;
    }

    private static InputStream getStreamForLocation(String filePath) throws FileNotFoundException {
        InputStream stream = null;
        stream = filePath.startsWith("file:///") ? new FileInputStream(filePath.replace("file:///", "")) : (filePath.startsWith("file:") || filePath.startsWith("/") ? new FileInputStream(filePath.replace("file:", "")) : JsonUtil.class.getClassLoader().getResourceAsStream(filePath.replace("classpath:", "")));
        return stream;
    }

    public static ArrayNode ensureArray(ObjectNode node, String field) {
        String[] path = Lists.newArrayList((Iterable)Splitter.on((char)'.').split((CharSequence)field)).toArray(new String[0]);
        ObjectNode current = node;
        ArrayNode result = null;
        for (int i = 0; i < path.length; ++i) {
            current = JsonUtil.ensureObject((ObjectNode)node.get(path[i]), path[i]);
        }
        if (current.get(field) == null) {
            current.put(field, (JsonNode)mapper.createArrayNode());
        }
        result = (ArrayNode)node.get(field);
        return result;
    }

    public static ObjectNode ensureObject(ObjectNode node, String field) {
        String[] path = Lists.newArrayList((Iterable)Splitter.on((char)'.').split((CharSequence)field)).toArray(new String[0]);
        ObjectNode current = node;
        ObjectNode result = null;
        for (int i = 0; i < path.length; ++i) {
            if (node.get(field) == null) {
                node.put(field, (JsonNode)mapper.createObjectNode());
            }
            current = (ObjectNode)node.get(field);
        }
        result = JsonUtil.ensureObject((ObjectNode)node.get(path[path.length]), Joiner.on((char)'.').join((Object[])Arrays.copyOfRange(path, 1, path.length)));
        return result;
    }
}

