/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streams.hdfs;

import com.google.common.base.Strings;
import com.google.common.util.concurrent.Uninterruptibles;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.concurrent.TimeUnit;
import java.util.zip.GZIPInputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.streams.core.DatumStatus;
import org.apache.streams.core.StreamsDatum;
import org.apache.streams.hdfs.HdfsWriterConfiguration;
import org.apache.streams.hdfs.WebHdfsPersistReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebHdfsPersistReaderTask
implements Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(WebHdfsPersistReaderTask.class);
    private WebHdfsPersistReader reader;

    public WebHdfsPersistReaderTask(WebHdfsPersistReader reader) {
        this.reader = reader;
    }

    @Override
    public void run() {
        LOGGER.info("WebHdfsPersistReaderTask: files to process");
        for (FileStatus fileStatus : this.reader.status) {
            LOGGER.info("    " + fileStatus.getPath().getName());
        }
        for (FileStatus fileStatus : this.reader.status) {
            BufferedReader bufferedReader;
            if (!fileStatus.isFile() || fileStatus.getPath().getName().startsWith("_")) continue;
            HdfsWriterConfiguration.Compression compression = HdfsWriterConfiguration.Compression.NONE;
            if (fileStatus.getPath().getName().endsWith(".gz")) {
                compression = HdfsWriterConfiguration.Compression.GZIP;
            }
            LOGGER.info("Started Processing: {} Encoding: {} Compression: {}", new Object[]{fileStatus.getPath().getName(), this.reader.hdfsConfiguration.getEncoding(), compression.toString()});
            try {
                Object inputStream = this.reader.client.open(fileStatus.getPath());
                if (compression.equals((Object)HdfsWriterConfiguration.Compression.GZIP)) {
                    inputStream = new GZIPInputStream((InputStream)inputStream);
                }
                InputStreamReader inputStreamReader = new InputStreamReader((InputStream)inputStream, this.reader.hdfsConfiguration.getEncoding());
                bufferedReader = new BufferedReader(inputStreamReader);
            }
            catch (Exception e) {
                LOGGER.error("Exception Opening " + fileStatus.getPath(), (Object)e.getMessage());
                return;
            }
            String line = "";
            do {
                try {
                    line = bufferedReader.readLine();
                    if (Strings.isNullOrEmpty((String)line)) continue;
                    this.reader.countersCurrent.incrementAttempt();
                    StreamsDatum entry = this.reader.lineReaderUtil.processLine(line);
                    if (entry != null) {
                        this.reader.write(entry);
                        this.reader.countersCurrent.incrementStatus(DatumStatus.SUCCESS);
                        continue;
                    }
                    LOGGER.warn("processLine failed");
                    this.reader.countersCurrent.incrementStatus(DatumStatus.FAIL);
                }
                catch (Exception e) {
                    LOGGER.warn("WebHdfsPersistReader readLine Exception: {}", (Throwable)e);
                    this.reader.countersCurrent.incrementStatus(DatumStatus.FAIL);
                }
            } while (!Strings.isNullOrEmpty((String)line));
            LOGGER.info("Finished Processing " + fileStatus.getPath().getName());
            try {
                bufferedReader.close();
            }
            catch (Exception e) {
                LOGGER.error("WebHdfsPersistReader Exception: {}", (Throwable)e);
            }
        }
        LOGGER.info("WebHdfsPersistReaderTask Finished");
        Uninterruptibles.sleepUninterruptibly((long)15L, (TimeUnit)TimeUnit.SECONDS);
    }
}

