/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streams.hdfs;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.streams.hdfs.HdfsConfiguration;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"writerPath", "writerFilePrefix", "linesPerFile", "compression"})
public class HdfsWriterConfiguration
extends HdfsConfiguration
implements Serializable {
    @JsonProperty(value="writerPath")
    private String writerPath;
    @JsonProperty(value="writerFilePrefix")
    private String writerFilePrefix;
    @JsonProperty(value="linesPerFile")
    private Long linesPerFile = 1000L;
    @JsonProperty(value="compression")
    private Compression compression = Compression.fromValue("none");
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    @JsonProperty(value="writerPath")
    public String getWriterPath() {
        return this.writerPath;
    }

    @JsonProperty(value="writerPath")
    public void setWriterPath(String writerPath) {
        this.writerPath = writerPath;
    }

    public HdfsWriterConfiguration withWriterPath(String writerPath) {
        this.writerPath = writerPath;
        return this;
    }

    @JsonProperty(value="writerFilePrefix")
    public String getWriterFilePrefix() {
        return this.writerFilePrefix;
    }

    @JsonProperty(value="writerFilePrefix")
    public void setWriterFilePrefix(String writerFilePrefix) {
        this.writerFilePrefix = writerFilePrefix;
    }

    public HdfsWriterConfiguration withWriterFilePrefix(String writerFilePrefix) {
        this.writerFilePrefix = writerFilePrefix;
        return this;
    }

    @JsonProperty(value="linesPerFile")
    public Long getLinesPerFile() {
        return this.linesPerFile;
    }

    @JsonProperty(value="linesPerFile")
    public void setLinesPerFile(Long linesPerFile) {
        this.linesPerFile = linesPerFile;
    }

    public HdfsWriterConfiguration withLinesPerFile(Long linesPerFile) {
        this.linesPerFile = linesPerFile;
        return this;
    }

    @JsonProperty(value="compression")
    public Compression getCompression() {
        return this.compression;
    }

    @JsonProperty(value="compression")
    public void setCompression(Compression compression) {
        this.compression = compression;
    }

    public HdfsWriterConfiguration withCompression(Compression compression) {
        this.compression = compression;
        return this;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    @Override
    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    @Override
    public HdfsWriterConfiguration withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.writerPath).append((Object)this.writerFilePrefix).append((Object)this.linesPerFile).append((Object)this.compression).append(this.additionalProperties).toHashCode();
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof HdfsWriterConfiguration)) {
            return false;
        }
        HdfsWriterConfiguration rhs = (HdfsWriterConfiguration)other;
        return new EqualsBuilder().append((Object)this.writerPath, (Object)rhs.writerPath).append((Object)this.writerFilePrefix, (Object)rhs.writerFilePrefix).append((Object)this.linesPerFile, (Object)rhs.linesPerFile).append((Object)this.compression, (Object)rhs.compression).append(this.additionalProperties, rhs.additionalProperties).isEquals();
    }

    public static enum Compression {
        NONE("none"),
        GZIP("gzip");

        private final String value;
        private static Map<String, Compression> constants;

        private Compression(String value) {
            this.value = value;
        }

        @JsonValue
        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static Compression fromValue(String value) {
            Compression constant = constants.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            constants = new HashMap<String, Compression>();
            for (Compression c : Compression.values()) {
                constants.put(c.value, c);
            }
        }
    }
}

