/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streams.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import com.typesafe.config.ConfigRenderOptions;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.streams.config.ComponentConfigurator;
import org.apache.streams.config.StreamsConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamsConfigurator {
    private static final Logger LOGGER = LoggerFactory.getLogger(ComponentConfigurator.class);
    private static final ObjectMapper mapper = new ObjectMapper();
    public static Config config = ConfigFactory.load();

    public static Config getConfig() {
        return config;
    }

    public static Config resolveConfig(String configUrl) throws MalformedURLException {
        URL url = new URL(configUrl);
        Config urlConfig = ConfigFactory.parseURL((URL)url);
        urlConfig.resolve();
        config = urlConfig;
        return config;
    }

    public static StreamsConfiguration detectConfiguration() {
        return StreamsConfigurator.detectConfiguration(config);
    }

    public static StreamsConfiguration detectConfiguration(Config typesafeConfig) {
        StreamsConfiguration pojoConfig = null;
        try {
            pojoConfig = (StreamsConfiguration)mapper.readValue(typesafeConfig.root().render(ConfigRenderOptions.concise()), StreamsConfiguration.class);
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.warn("Could not parse:", (Object)typesafeConfig);
        }
        return pojoConfig;
    }

    public static StreamsConfiguration mergeConfigurations(Config base, Config delta) {
        Config merged = delta.withFallback((ConfigMergeable)base);
        StreamsConfiguration pojoConfig = null;
        try {
            pojoConfig = (StreamsConfiguration)mapper.readValue(merged.root().render(ConfigRenderOptions.concise()), StreamsConfiguration.class);
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.warn("Failed to merge.");
        }
        return pojoConfig;
    }
}

