/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streams.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigRenderOptions;
import java.io.Serializable;
import org.apache.streams.config.StreamsConfigurator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComponentConfigurator<T extends Serializable> {
    private Class<T> configClass;
    private static final Logger LOGGER = LoggerFactory.getLogger(ComponentConfigurator.class);
    private static final ObjectMapper mapper = new ObjectMapper();

    public ComponentConfigurator(Class<T> configClass) {
        this.configClass = configClass;
    }

    public T detectConfiguration(Config typesafeConfig) {
        Serializable pojoConfig = null;
        try {
            pojoConfig = (Serializable)mapper.readValue(typesafeConfig.root().render(ConfigRenderOptions.concise()), this.configClass);
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.warn("Could not parse:", (Object)typesafeConfig);
        }
        return (T)pojoConfig;
    }

    public T detectConfiguration(String subConfig) {
        Config streamsConfig = StreamsConfigurator.getConfig();
        return this.detectConfiguration(streamsConfig.getConfig(subConfig));
    }

    public T detectConfiguration(Config typesafeConfig, String subConfig) {
        return this.detectConfiguration(typesafeConfig.getConfig(subConfig));
    }
}

