/*
 * Decompiled with CFR 0.152.
 */
package org.spark-project.guava.collect;

import java.io.Serializable;
import java.util.Map;
import org.spark-project.guava.annotations.GwtCompatible;
import org.spark-project.guava.annotations.GwtIncompatible;
import org.spark-project.guava.collect.ImmutableAsList;
import org.spark-project.guava.collect.ImmutableCollection;
import org.spark-project.guava.collect.ImmutableList;
import org.spark-project.guava.collect.ImmutableMap;
import org.spark-project.guava.collect.ImmutableSet;
import org.spark-project.guava.collect.Maps;
import org.spark-project.guava.collect.UnmodifiableIterator;

@GwtCompatible(emulated=true)
final class ImmutableMapValues<K, V>
extends ImmutableCollection<V> {
    private final ImmutableMap<K, V> map;

    ImmutableMapValues(ImmutableMap<K, V> map) {
        this.map = map;
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public UnmodifiableIterator<V> iterator() {
        return Maps.valueIterator(((ImmutableSet)this.map.entrySet()).iterator());
    }

    @Override
    public boolean contains(Object object) {
        return this.map.containsValue(object);
    }

    @Override
    boolean isPartialView() {
        return true;
    }

    @Override
    ImmutableList<V> createAsList() {
        final ImmutableList entryList = ((ImmutableCollection)((Object)this.map.entrySet())).asList();
        return new ImmutableAsList<V>(){

            @Override
            public V get(int index) {
                return ((Map.Entry)entryList.get(index)).getValue();
            }

            @Override
            ImmutableCollection<V> delegateCollection() {
                return ImmutableMapValues.this;
            }
        };
    }

    @Override
    @GwtIncompatible(value="serialization")
    Object writeReplace() {
        return new SerializedForm<V>(this.map);
    }

    @GwtIncompatible(value="serialization")
    private static class SerializedForm<V>
    implements Serializable {
        final ImmutableMap<?, V> map;
        private static final long serialVersionUID = 0L;

        SerializedForm(ImmutableMap<?, V> map) {
            this.map = map;
        }

        Object readResolve() {
            return this.map.values();
        }
    }
}

