/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.network.sasl;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import java.io.IOException;
import java.nio.ByteBuffer;
import javax.security.sasl.SaslException;
import org.apache.spark.network.client.TransportClient;
import org.apache.spark.network.client.TransportClientBootstrap;
import org.apache.spark.network.sasl.SaslEncryption;
import org.apache.spark.network.sasl.SaslMessage;
import org.apache.spark.network.sasl.SecretKeyHolder;
import org.apache.spark.network.sasl.SparkSaslClient;
import org.apache.spark.network.util.JavaUtils;
import org.apache.spark.network.util.TransportConf;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SaslClientBootstrap
implements TransportClientBootstrap {
    private final Logger logger = LoggerFactory.getLogger(SaslClientBootstrap.class);
    private final boolean encrypt;
    private final TransportConf conf;
    private final String appId;
    private final SecretKeyHolder secretKeyHolder;

    public SaslClientBootstrap(TransportConf conf, String appId, SecretKeyHolder secretKeyHolder) {
        this(conf, appId, secretKeyHolder, false);
    }

    public SaslClientBootstrap(TransportConf conf, String appId, SecretKeyHolder secretKeyHolder, boolean encrypt) {
        this.conf = conf;
        this.appId = appId;
        this.secretKeyHolder = secretKeyHolder;
        this.encrypt = encrypt;
    }

    @Override
    public void doBootstrap(TransportClient client, Channel channel) {
        SparkSaslClient saslClient = new SparkSaslClient(this.appId, this.secretKeyHolder, this.encrypt);
        try {
            byte[] payload = saslClient.firstToken();
            while (!saslClient.isComplete()) {
                SaslMessage msg = new SaslMessage(this.appId, payload);
                ByteBuf buf = Unpooled.buffer((int)(msg.encodedLength() + (int)msg.body().size()));
                msg.encode(buf);
                buf.writeBytes(msg.body().nioByteBuffer());
                ByteBuffer response = client.sendRpcSync(buf.nioBuffer(), this.conf.saslRTTimeoutMs());
                payload = saslClient.response(JavaUtils.bufferToArray(response));
            }
            client.setClientId(this.appId);
            if (this.encrypt) {
                if (!"auth-conf".equals(saslClient.getNegotiatedProperty("javax.security.sasl.qop"))) {
                    throw new RuntimeException(new SaslException("Encryption requests by negotiated non-encrypted connection."));
                }
                SaslEncryption.addToChannel(channel, saslClient, this.conf.maxSaslEncryptedBlockSize());
                saslClient = null;
                this.logger.debug("Channel {} configured for SASL encryption.", (Object)client);
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        finally {
            if (saslClient != null) {
                try {
                    saslClient.dispose();
                }
                catch (RuntimeException e) {
                    this.logger.error("Error while disposing SASL client", (Throwable)e);
                }
            }
        }
    }
}

