/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.regression;

import breeze.generic.UFunc;
import breeze.linalg.DenseVector;
import breeze.linalg.DenseVector$;
import breeze.linalg.ImmutableNumericOps;
import breeze.linalg.Vector;
import breeze.linalg.Vector$;
import breeze.storage.Zero;
import org.apache.spark.ml.regression.AFTPoint;
import org.apache.spark.mllib.linalg.Vectors$;
import scala.Array$;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichDouble$;

@ScalaSignature(bytes="\u0006\u0001Y4A!\u0001\u0002\u0005\u001b\ti\u0011I\u0012+BO\u001e\u0014XmZ1u_JT!a\u0001\u0003\u0002\u0015I,wM]3tg&|gN\u0003\u0002\u0006\r\u0005\u0011Q\u000e\u001c\u0006\u0003\u000f!\tQa\u001d9be.T!!\u0003\u0006\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005Y\u0011aA8sO\u000e\u00011c\u0001\u0001\u000f)A\u0011qBE\u0007\u0002!)\t\u0011#A\u0003tG\u0006d\u0017-\u0003\u0002\u0014!\t1\u0011I\\=SK\u001a\u0004\"aD\u000b\n\u0005Y\u0001\"\u0001D*fe&\fG.\u001b>bE2,\u0007\u0002\u0003\r\u0001\u0005\u0003\u0005\u000b\u0011B\r\u0002\u0015A\f'/Y7fi\u0016\u00148\u000fE\u0002\u001b?\u0005j\u0011a\u0007\u0006\u00039u\ta\u0001\\5oC2<'\"\u0001\u0010\u0002\r\t\u0014X-\u001a>f\u0013\t\u00013DA\u0006EK:\u001cXMV3di>\u0014\bCA\b#\u0013\t\u0019\u0003C\u0001\u0004E_V\u0014G.\u001a\u0005\tK\u0001\u0011\t\u0011)A\u0005M\u0005aa-\u001b;J]R,'oY3qiB\u0011qbJ\u0005\u0003QA\u0011qAQ8pY\u0016\fg\u000eC\u0003+\u0001\u0011\u00051&\u0001\u0004=S:LGO\u0010\u000b\u0004Y9z\u0003CA\u0017\u0001\u001b\u0005\u0011\u0001\"\u0002\r*\u0001\u0004I\u0002\"B\u0013*\u0001\u00041\u0003bB\u0019\u0001\u0005\u0004%IAM\u0001\u0005E\u0016$\u0018-F\u0001\u001a\u0011\u0019!\u0004\u0001)A\u00053\u0005)!-\u001a;bA!9a\u0007\u0001b\u0001\n\u00139\u0014!B:jO6\fW#A\u0011\t\re\u0002\u0001\u0015!\u0003\"\u0003\u0019\u0019\u0018nZ7bA!91\b\u0001a\u0001\n\u0013a\u0014\u0001\u0003;pi\u0006d7I\u001c;\u0016\u0003u\u0002\"a\u0004 \n\u0005}\u0002\"\u0001\u0002'p]\u001eDq!\u0011\u0001A\u0002\u0013%!)\u0001\u0007u_R\fGn\u00118u?\u0012*\u0017\u000f\u0006\u0002D\rB\u0011q\u0002R\u0005\u0003\u000bB\u0011A!\u00168ji\"9q\tQA\u0001\u0002\u0004i\u0014a\u0001=%c!1\u0011\n\u0001Q!\nu\n\u0011\u0002^8uC2\u001ce\u000e\u001e\u0011\t\u000f-\u0003\u0001\u0019!C\u0005o\u00059An\\:t'Vl\u0007bB'\u0001\u0001\u0004%IAT\u0001\fY>\u001c8oU;n?\u0012*\u0017\u000f\u0006\u0002D\u001f\"9q\tTA\u0001\u0002\u0004\t\u0003BB)\u0001A\u0003&\u0011%\u0001\u0005m_N\u001c8+^7!\u0011\u001d\u0019\u0006\u00011A\u0005\nI\nqb\u001a:bI&,g\u000e\u001e\"fi\u0006\u001cV/\u001c\u0005\b+\u0002\u0001\r\u0011\"\u0003W\u0003M9'/\u00193jK:$()\u001a;b'Vlw\fJ3r)\t\u0019u\u000bC\u0004H)\u0006\u0005\t\u0019A\r\t\re\u0003\u0001\u0015)\u0003\u001a\u0003A9'/\u00193jK:$()\u001a;b'Vl\u0007\u0005C\u0004\\\u0001\u0001\u0007I\u0011B\u001c\u0002'\u001d\u0014\u0018\rZ5f]RdunZ*jO6\f7+^7\t\u000fu\u0003\u0001\u0019!C\u0005=\u00069rM]1eS\u0016tG\u000fT8h'&<W.Y*v[~#S-\u001d\u000b\u0003\u0007~Cqa\u0012/\u0002\u0002\u0003\u0007\u0011\u0005\u0003\u0004b\u0001\u0001\u0006K!I\u0001\u0015OJ\fG-[3oi2{wmU5h[\u0006\u001cV/\u001c\u0011\t\u000b\r\u0004A\u0011\u0001\u001f\u0002\u000b\r|WO\u001c;\t\u000b\u0015\u0004A\u0011A\u001c\u0002\t1|7o\u001d\u0005\u0006O\u0002!\tAM\u0001\tOJ\fG-[3oi\")\u0011\u000e\u0001C\u0001U\u0006\u0019\u0011\r\u001a3\u0015\u0005-dW\"\u0001\u0001\t\u000b5D\u0007\u0019\u00018\u0002\t\u0011\fG/\u0019\t\u0003[=L!\u0001\u001d\u0002\u0003\u0011\u00053E\u000bU8j]RDQA\u001d\u0001\u0005\u0002M\fQ!\\3sO\u0016$\"a\u001b;\t\u000bU\f\b\u0019\u0001\u0017\u0002\u000b=$\b.\u001a:")
public class AFTAggregator
implements Serializable {
    private final boolean fitIntercept;
    private final DenseVector<Object> beta;
    private final double sigma;
    private long totalCnt;
    private double lossSum;
    private DenseVector<Object> gradientBetaSum;
    private double gradientLogSigmaSum;

    private DenseVector<Object> beta() {
        return this.beta;
    }

    private double sigma() {
        return this.sigma;
    }

    private long totalCnt() {
        return this.totalCnt;
    }

    private void totalCnt_$eq(long x$1) {
        this.totalCnt = x$1;
    }

    private double lossSum() {
        return this.lossSum;
    }

    private void lossSum_$eq(double x$1) {
        this.lossSum = x$1;
    }

    private DenseVector<Object> gradientBetaSum() {
        return this.gradientBetaSum;
    }

    private void gradientBetaSum_$eq(DenseVector<Object> x$1) {
        this.gradientBetaSum = x$1;
    }

    private double gradientLogSigmaSum() {
        return this.gradientLogSigmaSum;
    }

    private void gradientLogSigmaSum_$eq(double x$1) {
        this.gradientLogSigmaSum = x$1;
    }

    public long count() {
        return this.totalCnt();
    }

    public double loss() {
        return this.totalCnt() == 0L ? 1.0 : this.lossSum() / (double)this.totalCnt();
    }

    public DenseVector<Object> gradient() {
        return DenseVector$.MODULE$.vertcat((Seq)Predef$.MODULE$.wrapRefArray((Object[])new DenseVector[]{DenseVector$.MODULE$.apply$mDc$sp(new double[]{this.gradientLogSigmaSum() / (double)this.totalCnt()}), (DenseVector)this.gradientBetaSum().$div((Object)BoxesRunTime.boxToDouble((double)this.totalCnt()), DenseVector$.MODULE$.dv_s_Op_Double_OpDiv())}), DenseVector$.MODULE$.canSetD(), ClassTag$.MODULE$.Double(), (Zero)Zero.DoubleZero$.MODULE$);
    }

    public AFTAggregator add(AFTPoint data) {
        Vector<Object> xi = this.fitIntercept ? Vectors$.MODULE$.dense((double[])Predef$.MODULE$.doubleArrayOps(new double[]{1.0}).$plus$plus((GenTraversableOnce)Predef$.MODULE$.doubleArrayOps(data.features().toArray()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()))).toBreeze() : Vectors$.MODULE$.dense((double[])Predef$.MODULE$.doubleArrayOps(new double[]{0.0}).$plus$plus((GenTraversableOnce)Predef$.MODULE$.doubleArrayOps(data.features().toArray()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()))).toBreeze();
        double ti = data.label();
        double delta = data.censor();
        double epsilon = (package$.MODULE$.log(ti) - BoxesRunTime.unboxToDouble((Object)this.beta().dot(xi, DenseVector$.MODULE$.canDot_DV_V_Double()))) / this.sigma();
        this.lossSum_$eq(this.lossSum() + package$.MODULE$.log(this.sigma()) * delta);
        this.lossSum_$eq(this.lossSum() + (package$.MODULE$.exp(epsilon) - delta * epsilon));
        Predef$.MODULE$.assert(!RichDouble$.MODULE$.isInfinity$extension(Predef$.MODULE$.doubleWrapper(this.lossSum())), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"AFTAggregator loss sum is infinity. Error for unknown reason."})).s((Seq)Nil$.MODULE$);
            }
        });
        this.gradientBetaSum().$plus$eq(((ImmutableNumericOps)xi.$times((Object)BoxesRunTime.boxToDouble((double)(delta - package$.MODULE$.exp(epsilon))), (UFunc.UImpl2)Vector$.MODULE$.v_s_Op_Double_OpMulMatrix())).$div((Object)BoxesRunTime.boxToDouble((double)this.sigma()), (UFunc.UImpl2)Vector$.MODULE$.v_s_Op_Double_OpDiv()), (UFunc.InPlaceImpl2)DenseVector$.MODULE$.dv_v_ZeroIdempotent_InPlaceOp_Double_OpAdd());
        this.gradientLogSigmaSum_$eq(this.gradientLogSigmaSum() + (delta + (delta - package$.MODULE$.exp(epsilon)) * epsilon));
        this.totalCnt_$eq(this.totalCnt() + 1L);
        return this;
    }

    public AFTAggregator merge(AFTAggregator other) {
        if (other.count() != 0L) {
            this.totalCnt_$eq(this.totalCnt() + other.totalCnt());
            this.lossSum_$eq(this.lossSum() + other.lossSum());
            this.gradientBetaSum().$plus$eq(other.gradientBetaSum(), DenseVector$.MODULE$.canAddIntoD());
            this.gradientLogSigmaSum_$eq(this.gradientLogSigmaSum() + other.gradientLogSigmaSum());
        }
        return this;
    }

    public AFTAggregator(DenseVector<Object> parameters, boolean fitIntercept) {
        this.fitIntercept = fitIntercept;
        this.beta = parameters.slice$mcD$sp(1, parameters.length(), parameters.slice$default$3());
        this.sigma = package$.MODULE$.exp(parameters.apply$mcD$sp(0));
        this.totalCnt = 0L;
        this.lossSum = 0.0;
        this.gradientBetaSum = DenseVector$.MODULE$.zeros$mDc$sp(this.beta().length(), ClassTag$.MODULE$.Double(), (Zero)Zero.DoubleZero$.MODULE$);
        this.gradientLogSigmaSum = 0.0;
    }
}

