/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.hadoop.metadata;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import org.apache.parquet.hadoop.metadata.BlockMetaData;
import org.apache.parquet.hadoop.metadata.FileMetaData;
import shaded.parquet.org.codehaus.jackson.JsonGenerationException;
import shaded.parquet.org.codehaus.jackson.JsonParseException;
import shaded.parquet.org.codehaus.jackson.map.JsonMappingException;
import shaded.parquet.org.codehaus.jackson.map.ObjectMapper;
import shaded.parquet.org.codehaus.jackson.map.SerializationConfig;

public class ParquetMetadata {
    private static final ObjectMapper objectMapper = new ObjectMapper();
    private final FileMetaData fileMetaData;
    private final List<BlockMetaData> blocks;

    public static String toJSON(ParquetMetadata parquetMetaData) {
        return ParquetMetadata.toJSON(parquetMetaData, false);
    }

    public static String toPrettyJSON(ParquetMetadata parquetMetaData) {
        return ParquetMetadata.toJSON(parquetMetaData, true);
    }

    private static String toJSON(ParquetMetadata parquetMetaData, boolean isPrettyPrint) {
        StringWriter stringWriter = new StringWriter();
        try {
            if (isPrettyPrint) {
                objectMapper.writerWithDefaultPrettyPrinter().writeValue((Writer)stringWriter, (Object)parquetMetaData);
            } else {
                objectMapper.writeValue((Writer)stringWriter, (Object)parquetMetaData);
            }
        }
        catch (JsonGenerationException e) {
            throw new RuntimeException(e);
        }
        catch (JsonMappingException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return stringWriter.toString();
    }

    public static ParquetMetadata fromJSON(String json) {
        try {
            return (ParquetMetadata)objectMapper.readValue((Reader)new StringReader(json), ParquetMetadata.class);
        }
        catch (JsonParseException e) {
            throw new RuntimeException(e);
        }
        catch (JsonMappingException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public ParquetMetadata(FileMetaData fileMetaData, List<BlockMetaData> blocks) {
        this.fileMetaData = fileMetaData;
        this.blocks = blocks;
    }

    public List<BlockMetaData> getBlocks() {
        return this.blocks;
    }

    public FileMetaData getFileMetaData() {
        return this.fileMetaData;
    }

    public String toString() {
        return "ParquetMetaData{" + this.fileMetaData + ", blocks: " + this.blocks + "}";
    }

    static {
        objectMapper.configure(SerializationConfig.Feature.FAIL_ON_EMPTY_BEANS, false);
    }
}

