/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.processors;

import com.google.common.base.Joiner;
import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.processors.CommandProcessor;
import org.apache.hadoop.hive.ql.processors.CommandProcessorResponse;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.shims.HadoopShims;
import org.apache.hadoop.hive.shims.ShimLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ErasureProcessor
implements CommandProcessor {
    private static final Logger LOG = LoggerFactory.getLogger((String)ErasureProcessor.class.getName());
    private HadoopShims.HdfsErasureCodingShim erasureCodingShim;
    private Comparator<HadoopShims.HdfsFileErasureCodingPolicy> nameComparator = Comparator.comparing(HadoopShims.HdfsFileErasureCodingPolicy::getName);

    ErasureProcessor(HiveConf config) throws IOException {
        this.erasureCodingShim = ErasureProcessor.getErasureShim(config);
    }

    public static HadoopShims.HdfsErasureCodingShim getErasureShim(Configuration config) throws IOException {
        HadoopShims hadoopShims = ShimLoader.getHadoopShims();
        FileSystem fileSystem = FileSystem.get((Configuration)config);
        return hadoopShims.createHdfsErasureCodingShim(fileSystem, config);
    }

    private CommandLine parseCommandArgs(Options opts, String[] args) throws ParseException {
        GnuParser parser = new GnuParser();
        return parser.parse(opts, args);
    }

    private CommandProcessorResponse returnErrorResponse(String errmsg) {
        return new CommandProcessorResponse(1, "Erasure Processor Helper Failed: " + errmsg, null);
    }

    private void writeTestOutput(String msg) {
        SessionState.get().out.println(msg);
    }

    @Override
    public void init() {
    }

    @Override
    public CommandProcessorResponse run(String command) {
        String[] args = command.split("\\s+");
        if (args.length < 1) {
            return this.returnErrorResponse("Command arguments are empty.");
        }
        if (this.erasureCodingShim == null) {
            return this.returnErrorResponse("Hadoop erasure shim is not initialized.");
        }
        String action = args[0].toLowerCase();
        String[] params = Arrays.copyOfRange(args, 1, args.length);
        try {
            switch (action) {
                case "disablepolicy": {
                    this.disablePolicy(params);
                    break;
                }
                case "echo": {
                    this.echo(params);
                    break;
                }
                case "enablepolicy": {
                    this.enablePolicy(params);
                    break;
                }
                case "getpolicy": {
                    this.getPolicy(params);
                    break;
                }
                case "listpolicies": {
                    this.listPolicies();
                    break;
                }
                case "setpolicy": {
                    this.setPolicy(params);
                    break;
                }
                case "removepolicy": {
                    this.removePolicy(params);
                    break;
                }
                case "unsetpolicy": {
                    this.unsetPolicy(params);
                    break;
                }
                default: {
                    return this.returnErrorResponse("Unknown erasure command action: " + action);
                }
            }
        }
        catch (Exception e) {
            return this.returnErrorResponse(e.getMessage());
        }
        return new CommandProcessorResponse(0);
    }

    private void getPolicy(String[] params) throws Exception {
        String command = "getPolicy";
        try {
            Options getPolicyOptions = new Options();
            String pathOptionName = "path";
            OptionBuilder.hasArg();
            OptionBuilder.isRequired();
            OptionBuilder.withLongOpt((String)pathOptionName);
            OptionBuilder.withDescription((String)"Path for which Policy should be fetched");
            Option policyOption = OptionBuilder.create();
            getPolicyOptions.addOption(policyOption);
            CommandLine args = this.parseCommandArgs(getPolicyOptions, params);
            String path = args.getOptionValue(pathOptionName);
            HadoopShims.HdfsFileErasureCodingPolicy policy = this.erasureCodingShim.getErasureCodingPolicy(new Path(path));
            this.writeTestOutput("EC policy is '" + (policy != null ? policy.getName() : "REPLICATED") + "'");
        }
        catch (ParseException pe) {
            this.writeTestOutput("Error parsing options for " + command + " " + pe.getMessage());
        }
        catch (Exception e) {
            this.writeTestOutput("Caught exception running " + command + ": " + e.getMessage());
            throw new Exception("Cannot run " + command + ": " + e.getMessage(), e);
        }
    }

    private void echo(String[] params) throws Exception {
        String command = "echo";
        try {
            this.writeTestOutput("ECHO " + Joiner.on(" ").join(params));
        }
        catch (Exception e) {
            this.writeTestOutput("Caught exception running " + command + ": " + e.getMessage());
            throw new Exception("Cannot run " + command + ": " + e.getMessage());
        }
    }

    private void enablePolicy(String[] params) throws Exception {
        String command = "enablePolicy";
        try {
            Options enablePolicyOptions = new Options();
            String policyOptionName = "policy";
            OptionBuilder.hasArg();
            OptionBuilder.isRequired();
            OptionBuilder.withLongOpt((String)policyOptionName);
            OptionBuilder.withDescription((String)"Policy to enable");
            OptionBuilder.hasArg();
            Option policyOption = OptionBuilder.create();
            enablePolicyOptions.addOption(policyOption);
            CommandLine args = this.parseCommandArgs(enablePolicyOptions, params);
            String policyName = args.getOptionValue(policyOptionName);
            this.erasureCodingShim.enableErasureCodingPolicy(policyName);
            this.writeTestOutput("Enabled EC policy '" + policyName + "'");
        }
        catch (ParseException pe) {
            this.writeTestOutput("Error parsing options for " + command + " " + pe.getMessage());
        }
        catch (Exception e) {
            this.writeTestOutput("Caught exception running " + command + ": " + e.getMessage());
            throw new Exception("Cannot run " + command + ": " + e.getMessage());
        }
    }

    private void removePolicy(String[] params) throws Exception {
        String command = "removePolicy";
        try {
            Options removePolicyOptions = new Options();
            String policyOptionName = "policy";
            OptionBuilder.hasArg();
            OptionBuilder.isRequired();
            OptionBuilder.withLongOpt((String)policyOptionName);
            OptionBuilder.withDescription((String)"Policy to remove");
            Option policyOption = OptionBuilder.create();
            removePolicyOptions.addOption(policyOption);
            CommandLine args = this.parseCommandArgs(removePolicyOptions, params);
            String policyName = args.getOptionValue(policyOptionName);
            this.erasureCodingShim.removeErasureCodingPolicy(policyName);
            this.writeTestOutput("Removed EC policy '" + policyName + "'");
        }
        catch (ParseException pe) {
            this.writeTestOutput("Error parsing options for " + command + " " + pe.getMessage());
        }
        catch (Exception e) {
            this.writeTestOutput("Caught exception running " + command + ": " + e.getMessage());
            throw new Exception("Cannot run " + command + ": " + e.getMessage());
        }
    }

    private void disablePolicy(String[] params) throws Exception {
        String command = "disablePolicy";
        try {
            Options disablePolicyOptions = new Options();
            String policyOptionName = "policy";
            OptionBuilder.hasArg();
            OptionBuilder.isRequired();
            OptionBuilder.withLongOpt((String)policyOptionName);
            OptionBuilder.withDescription((String)"Policy to disable");
            Option policyOption = OptionBuilder.create();
            disablePolicyOptions.addOption(policyOption);
            CommandLine args = this.parseCommandArgs(disablePolicyOptions, params);
            String policyName = args.getOptionValue(policyOptionName);
            this.erasureCodingShim.disableErasureCodingPolicy(policyName);
            this.writeTestOutput("Disabled EC policy '" + policyName + "'");
        }
        catch (ParseException pe) {
            this.writeTestOutput("Error parsing options for " + command + " " + pe.getMessage());
        }
        catch (Exception e) {
            this.writeTestOutput("Caught exception running " + command + ": " + e.getMessage());
            throw new Exception("Cannot run " + command + ": " + e.getMessage());
        }
    }

    private void setPolicy(String[] params) throws Exception {
        String command = "setPolicy";
        try {
            Options setPolicyOptions = new Options();
            String pathOptionName = "path";
            OptionBuilder.hasArg();
            OptionBuilder.isRequired();
            OptionBuilder.withLongOpt((String)pathOptionName);
            OptionBuilder.withDescription((String)"Path to set policy on");
            Option pathOption = OptionBuilder.create();
            setPolicyOptions.addOption(pathOption);
            String policyOptionName = "policy";
            OptionBuilder.hasArg();
            OptionBuilder.withLongOpt((String)policyOptionName);
            OptionBuilder.withDescription((String)"Policy to set");
            Option policyOption = OptionBuilder.create();
            setPolicyOptions.addOption(policyOption);
            CommandLine args = this.parseCommandArgs(setPolicyOptions, params);
            String path = args.getOptionValue(pathOptionName);
            String policy = args.getOptionValue(policyOptionName);
            this.erasureCodingShim.setErasureCodingPolicy(new Path(path), policy);
            this.writeTestOutput("Set EC policy' " + policy);
        }
        catch (ParseException pe) {
            this.writeTestOutput("Error parsing options for " + command + " " + pe.getMessage());
        }
        catch (Exception e) {
            this.writeTestOutput("Caught exception running " + command + ": " + e.getMessage());
            throw new Exception("Cannot run " + command + ": " + e.getMessage());
        }
    }

    private void unsetPolicy(String[] params) throws Exception {
        String command = "unsetPolicy";
        try {
            Options unsetPolicyOptions = new Options();
            String pathOptionName = "path";
            OptionBuilder.hasArg();
            OptionBuilder.isRequired();
            OptionBuilder.withLongOpt((String)pathOptionName);
            OptionBuilder.withDescription((String)"Path to unset policy on");
            Option pathOption = OptionBuilder.create();
            unsetPolicyOptions.addOption(pathOption);
            CommandLine args = this.parseCommandArgs(unsetPolicyOptions, params);
            String path = args.getOptionValue(pathOptionName);
            this.erasureCodingShim.unsetErasureCodingPolicy(new Path(path));
            this.writeTestOutput("Unset EC policy");
        }
        catch (ParseException pe) {
            this.writeTestOutput("Error parsing options for " + command + " " + pe.getMessage());
        }
        catch (Exception e) {
            this.writeTestOutput("Caught exception running " + command + ": " + e.getMessage());
            throw new Exception("Cannot run " + command + ": " + e.getMessage());
        }
    }

    private void listPolicies() throws Exception {
        try {
            List<HadoopShims.HdfsFileErasureCodingPolicy> erasureCodingPolicies = this.erasureCodingShim.getAllErasureCodingPolicies();
            erasureCodingPolicies.sort(this.nameComparator);
            if (erasureCodingPolicies.isEmpty()) {
                this.writeTestOutput("No EC Policies present");
            }
            for (HadoopShims.HdfsFileErasureCodingPolicy policy : erasureCodingPolicies) {
                this.writeTestOutput("Policy: " + policy.getName() + " " + policy.getStatus());
            }
        }
        catch (Exception e) {
            throw new Exception("Cannot do language command: " + e.getMessage());
        }
    }
}

