/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.plan;

import com.google.common.collect.Interner;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.StringInternUtils;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.FileSinkOperator;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.OperatorUtils;
import org.apache.hadoop.hive.ql.exec.TableScanOperator;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.io.AcidUtils;
import org.apache.hadoop.hive.ql.io.HiveInputFormat;
import org.apache.hadoop.hive.ql.optimizer.physical.BucketingSortingCtx;
import org.apache.hadoop.hive.ql.optimizer.physical.VectorizerReason;
import org.apache.hadoop.hive.ql.parse.SplitSample;
import org.apache.hadoop.hive.ql.plan.BaseWork;
import org.apache.hadoop.hive.ql.plan.Explain;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.FileSinkDesc;
import org.apache.hadoop.hive.ql.plan.MapredLocalWork;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.PartitionDesc;
import org.apache.hadoop.hive.ql.plan.PlanUtils;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.hive.ql.plan.VectorizationCondition;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.hadoop.mapred.JobConf;

public class MapWork
extends BaseWork {
    private LinkedHashMap<Path, ArrayList<String>> pathToAliases = new LinkedHashMap();
    private LinkedHashMap<Path, PartitionDesc> pathToPartitionInfo = new LinkedHashMap();
    private LinkedHashMap<String, Operator<? extends OperatorDesc>> aliasToWork = new LinkedHashMap();
    private LinkedHashMap<String, PartitionDesc> aliasToPartnInfo = new LinkedHashMap();
    private HashMap<String, SplitSample> nameToSplitSample = new LinkedHashMap<String, SplitSample>();
    private final Map<String, List<BucketingSortingCtx.BucketCol>> bucketedColsByDirectory = new HashMap<String, List<BucketingSortingCtx.BucketCol>>();
    private final Map<String, List<BucketingSortingCtx.SortCol>> sortedColsByDirectory = new HashMap<String, List<BucketingSortingCtx.SortCol>>();
    private Path tmpHDFSPath;
    private Path tmpPathForPartitionPruning;
    private String inputformat;
    private String indexIntermediateFile;
    private Integer numMapTasks;
    private Long maxSplitSize;
    private Long minSplitSize;
    private Long minSplitSizePerNode;
    private Long minSplitSizePerRack;
    private int samplingType;
    public static final int SAMPLING_ON_PREV_MR = 1;
    public static final int SAMPLING_ON_START = 2;
    private boolean leftInputJoin;
    private String[] baseSrc;
    private List<String> mapAliases;
    private boolean mapperCannotSpanPartns;
    private boolean inputFormatSorted = false;
    private boolean useBucketizedHiveInputFormat;
    private boolean dummyTableScan = false;
    private Map<String, List<TableDesc>> eventSourceTableDescMap = new LinkedHashMap<String, List<TableDesc>>();
    private Map<String, List<String>> eventSourceColumnNameMap = new LinkedHashMap<String, List<String>>();
    private Map<String, List<String>> eventSourceColumnTypeMap = new LinkedHashMap<String, List<String>>();
    private Map<String, List<ExprNodeDesc>> eventSourcePartKeyExprMap = new LinkedHashMap<String, List<ExprNodeDesc>>();
    private boolean doSplitsGrouping = true;
    private VectorizedRowBatch vectorizedRowBatch;
    private VectorizerReason notEnabledInputFileFormatReason;
    private Set<String> vectorizationInputFileFormatClassNameSet;
    private List<String> vectorizationEnabledConditionsMet;
    private List<String> vectorizationEnabledConditionsNotMet;
    private byte[] includedBuckets;
    private String llapIoDesc;

    public MapWork() {
    }

    public MapWork(String name) {
        super(name);
    }

    @Explain(displayName="Path -> Alias", explainLevels={Explain.Level.EXTENDED})
    @Deprecated
    public LinkedHashMap<String, ArrayList<String>> getPathToAliasesOld() {
        LinkedHashMap<String, ArrayList<String>> ret = new LinkedHashMap<String, ArrayList<String>>();
        for (Map.Entry<Path, ArrayList<String>> p2a : this.pathToAliases.entrySet()) {
            ret.put(p2a.getKey().toString(), p2a.getValue());
        }
        return ret;
    }

    public LinkedHashMap<Path, ArrayList<String>> getPathToAliases() {
        return this.pathToAliases;
    }

    public void setPathToAliases(LinkedHashMap<Path, ArrayList<String>> pathToAliases) {
        for (Path p : pathToAliases.keySet()) {
            StringInternUtils.internUriStringsInPath(p);
        }
        this.pathToAliases = pathToAliases;
    }

    public void addPathToAlias(Path path, ArrayList<String> aliases) {
        StringInternUtils.internUriStringsInPath(path);
        this.pathToAliases.put(path, aliases);
    }

    public void addPathToAlias(Path path, String newAlias) {
        ArrayList<String> aliases = this.pathToAliases.get(path);
        if (aliases == null) {
            aliases = new ArrayList();
            StringInternUtils.internUriStringsInPath(path);
            this.pathToAliases.put(path, aliases);
        }
        aliases.add(newAlias.intern());
    }

    public void removePathToAlias(Path path) {
        this.pathToAliases.remove(path);
    }

    @Explain(displayName="Truncated Path -> Alias", explainLevels={Explain.Level.EXTENDED})
    public Map<String, ArrayList<String>> getTruncatedPathToAliases() {
        LinkedHashMap<String, ArrayList<String>> trunPathToAliases = new LinkedHashMap<String, ArrayList<String>>();
        for (Map.Entry<Path, ArrayList<String>> entry : this.pathToAliases.entrySet()) {
            Path origiKey = entry.getKey();
            String newKey = PlanUtils.removePrefixFromWarehouseConfig(origiKey.toString());
            ArrayList<String> value = entry.getValue();
            trunPathToAliases.put(newKey, value);
        }
        return trunPathToAliases;
    }

    @Explain(displayName="Path -> Partition", explainLevels={Explain.Level.EXTENDED})
    @Deprecated
    public LinkedHashMap<String, PartitionDesc> getPathToPartitionInfoOld() {
        LinkedHashMap<String, PartitionDesc> ret = new LinkedHashMap<String, PartitionDesc>();
        for (Map.Entry<Path, PartitionDesc> p2a : this.pathToPartitionInfo.entrySet()) {
            ret.put(p2a.getKey().toString(), p2a.getValue());
        }
        return ret;
    }

    public LinkedHashMap<Path, PartitionDesc> getPathToPartitionInfo() {
        return this.pathToPartitionInfo;
    }

    public void setPathToPartitionInfo(LinkedHashMap<Path, PartitionDesc> pathToPartitionInfo) {
        for (Path p : pathToPartitionInfo.keySet()) {
            StringInternUtils.internUriStringsInPath(p);
        }
        this.pathToPartitionInfo = pathToPartitionInfo;
    }

    public void addPathToPartitionInfo(Path path, PartitionDesc partitionInfo) {
        if (this.pathToPartitionInfo == null) {
            this.pathToPartitionInfo = new LinkedHashMap();
        }
        this.pathToPartitionInfo.put(path, partitionInfo);
    }

    public void removePathToPartitionInfo(Path path) {
        this.pathToPartitionInfo.remove(path);
    }

    public void deriveExplainAttributes() {
        MapredLocalWork mapLocalWork;
        if (this.pathToPartitionInfo != null) {
            for (Map.Entry<Path, PartitionDesc> entry : this.pathToPartitionInfo.entrySet()) {
                entry.getValue().deriveBaseFileName(entry.getKey());
            }
        }
        if ((mapLocalWork = this.getMapRedLocalWork()) != null) {
            mapLocalWork.deriveExplainAttributes();
        }
    }

    public void deriveLlap(Configuration conf) {
        boolean hasPathToPartInfo;
        boolean hasLlap = false;
        boolean hasNonLlap = false;
        boolean hasAcid = false;
        boolean isLlapOn = HiveConf.getBoolVar(conf, HiveConf.ConfVars.LLAP_IO_ENABLED, this.llapMode);
        boolean canWrapAny = isLlapOn && HiveInputFormat.canWrapAnyForLlap(conf, this);
        boolean bl = hasPathToPartInfo = this.pathToPartitionInfo != null && !this.pathToPartitionInfo.isEmpty();
        if (canWrapAny && hasPathToPartInfo) {
            assert (isLlapOn);
            for (PartitionDesc partitionDesc : this.pathToPartitionInfo.values()) {
                boolean isUsingLlapIo = HiveInputFormat.canWrapForLlap(partitionDesc.getInputFileFormatClass());
                if (isUsingLlapIo) {
                    if (partitionDesc.getTableDesc() != null && AcidUtils.isTablePropertyTransactional(partitionDesc.getTableDesc().getProperties())) {
                        hasAcid = true;
                        continue;
                    }
                    hasLlap = true;
                    continue;
                }
                hasNonLlap = true;
            }
        }
        for (Map.Entry entry : this.aliasToWork.entrySet()) {
            if (!hasLlap) continue;
            String alias = (String)entry.getKey();
            Operator op = (Operator)entry.getValue();
            PartitionDesc partitionDesc = this.aliasToPartnInfo.get(alias);
            if (!(op instanceof TableScanOperator) || partitionDesc == null || partitionDesc.getTableDesc() == null) continue;
            TableScanOperator tsOp = (TableScanOperator)op;
            List<String> readColumnNames = tsOp.getNeededColumns();
            Properties props = partitionDesc.getTableDesc().getProperties();
            ArrayList<TypeInfo> typeInfos = TypeInfoUtils.getTypeInfosFromTypeString(props.getProperty("columns.types"));
            List<String> allColumnTypes = TypeInfoUtils.getTypeStringsFromTypeInfo(typeInfos);
            List<String> allColumnNames = Utilities.getColumnNames(props);
            hasLlap = Utilities.checkLlapIOSupportedTypes(readColumnNames, allColumnNames, allColumnTypes);
        }
        this.llapIoDesc = MapWork.deriveLlapIoDescString(isLlapOn, canWrapAny, hasPathToPartInfo, hasLlap, hasNonLlap, hasAcid);
    }

    private static String deriveLlapIoDescString(boolean isLlapOn, boolean canWrapAny, boolean hasPathToPartInfo, boolean hasLlap, boolean hasNonLlap, boolean hasAcid) {
        if (!isLlapOn) {
            return null;
        }
        if (!canWrapAny) {
            return "no inputs";
        }
        if (!hasPathToPartInfo) {
            return "unknown";
        }
        if (hasAcid) {
            return "may be used (ACID table)";
        }
        return hasLlap ? (hasNonLlap ? "some inputs" : "all inputs") : "no inputs";
    }

    public void internTable(Interner<TableDesc> interner) {
        if (this.aliasToPartnInfo != null) {
            for (PartitionDesc part : this.aliasToPartnInfo.values()) {
                if (part == null) continue;
                part.intern(interner);
            }
        }
        if (this.pathToPartitionInfo != null) {
            for (PartitionDesc part : this.pathToPartitionInfo.values()) {
                part.intern(interner);
            }
        }
    }

    public LinkedHashMap<String, PartitionDesc> getAliasToPartnInfo() {
        return this.aliasToPartnInfo;
    }

    public void setAliasToPartnInfo(LinkedHashMap<String, PartitionDesc> aliasToPartnInfo) {
        this.aliasToPartnInfo = aliasToPartnInfo;
    }

    public LinkedHashMap<String, Operator<? extends OperatorDesc>> getAliasToWork() {
        return this.aliasToWork;
    }

    public void setAliasToWork(LinkedHashMap<String, Operator<? extends OperatorDesc>> aliasToWork) {
        this.aliasToWork = aliasToWork;
    }

    @Explain(displayName="Split Sample", explainLevels={Explain.Level.EXTENDED})
    public HashMap<String, SplitSample> getNameToSplitSample() {
        return this.nameToSplitSample;
    }

    @Explain(displayName="LLAP IO", vectorization=Explain.Vectorization.SUMMARY_PATH)
    public String getLlapIoDesc() {
        return this.llapIoDesc;
    }

    public void setNameToSplitSample(HashMap<String, SplitSample> nameToSplitSample) {
        this.nameToSplitSample = nameToSplitSample;
    }

    public Integer getNumMapTasks() {
        return this.numMapTasks;
    }

    public void setNumMapTasks(Integer numMapTasks) {
        this.numMapTasks = numMapTasks;
    }

    public void addMapWork(Path path, String alias, Operator<?> work, PartitionDesc pd) {
        StringInternUtils.internUriStringsInPath(path);
        ArrayList<String> curAliases = this.pathToAliases.get(path);
        if (curAliases == null) {
            assert (this.pathToPartitionInfo.get(path) == null);
            curAliases = new ArrayList();
            this.pathToAliases.put(path, curAliases);
            this.pathToPartitionInfo.put(path, pd);
        } else assert (this.pathToPartitionInfo.get(path) != null);
        for (String oneAlias : curAliases) {
            if (!oneAlias.equals(alias)) continue;
            throw new RuntimeException("Multiple aliases named: " + alias + " for path: " + path);
        }
        curAliases.add(alias);
        if (this.aliasToWork.get(alias) != null) {
            throw new RuntimeException("Existing work for alias: " + alias);
        }
        this.aliasToWork.put(alias, work);
    }

    public boolean isInputFormatSorted() {
        return this.inputFormatSorted;
    }

    public void setInputFormatSorted(boolean inputFormatSorted) {
        this.inputFormatSorted = inputFormatSorted;
    }

    public void resolveDynamicPartitionStoredAsSubDirsMerge(HiveConf conf, Path path, TableDesc tblDesc, ArrayList<String> aliases, PartitionDesc partDesc) {
        StringInternUtils.internUriStringsInPath(path);
        this.pathToAliases.put(path, aliases);
        this.pathToPartitionInfo.put(path, partDesc);
    }

    private void setAliases() {
        if (this.aliasToWork == null) {
            return;
        }
        for (String oneAlias : this.aliasToWork.keySet()) {
            this.aliasToWork.get(oneAlias).setAlias(oneAlias);
        }
    }

    @Explain(displayName="Execution mode", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED}, vectorization=Explain.Vectorization.SUMMARY_PATH)
    public String getExecutionMode() {
        if (this.vectorMode) {
            if (this.llapMode) {
                if (this.uberMode) {
                    return "vectorized, uber";
                }
                return "vectorized, llap";
            }
            return "vectorized";
        }
        if (this.llapMode) {
            return this.uberMode ? "uber" : "llap";
        }
        return null;
    }

    @Override
    public void replaceRoots(Map<Operator<?>, Operator<?>> replacementMap) {
        LinkedHashMap<String, Operator<? extends OperatorDesc>> newAliasToWork = new LinkedHashMap<String, Operator<? extends OperatorDesc>>();
        for (Map.Entry<String, Operator<? extends OperatorDesc>> entry : this.aliasToWork.entrySet()) {
            newAliasToWork.put(entry.getKey(), replacementMap.get(entry.getValue()));
        }
        this.setAliasToWork(newAliasToWork);
    }

    @Override
    @Explain(displayName="Map Operator Tree", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED}, vectorization=Explain.Vectorization.OPERATOR_PATH)
    public Set<Operator<? extends OperatorDesc>> getAllRootOperators() {
        LinkedHashSet<Operator<? extends OperatorDesc>> opSet = new LinkedHashSet<Operator<? extends OperatorDesc>>();
        for (Operator<? extends OperatorDesc> op : this.getAliasToWork().values()) {
            opSet.add(op);
        }
        return opSet;
    }

    @Override
    public Operator<? extends OperatorDesc> getAnyRootOperator() {
        return this.aliasToWork.isEmpty() ? null : this.aliasToWork.values().iterator().next();
    }

    public void mergeAliasedInput(String alias, Path pathDir, PartitionDesc partitionInfo) {
        StringInternUtils.internUriStringsInPath(pathDir);
        alias = alias.intern();
        ArrayList<String> aliases = this.pathToAliases.get(pathDir);
        if (aliases == null) {
            aliases = new ArrayList<String>(Arrays.asList(alias));
            this.pathToAliases.put(pathDir, aliases);
            this.pathToPartitionInfo.put(pathDir, partitionInfo);
        } else {
            aliases.add(alias);
        }
    }

    public void initialize() {
        this.setAliases();
    }

    public Long getMaxSplitSize() {
        return this.maxSplitSize;
    }

    public void setMaxSplitSize(Long maxSplitSize) {
        this.maxSplitSize = maxSplitSize;
    }

    public Long getMinSplitSize() {
        return this.minSplitSize;
    }

    public void setMinSplitSize(Long minSplitSize) {
        this.minSplitSize = minSplitSize;
    }

    public Long getMinSplitSizePerNode() {
        return this.minSplitSizePerNode;
    }

    public void setMinSplitSizePerNode(Long minSplitSizePerNode) {
        this.minSplitSizePerNode = minSplitSizePerNode;
    }

    public Long getMinSplitSizePerRack() {
        return this.minSplitSizePerRack;
    }

    public void setMinSplitSizePerRack(Long minSplitSizePerRack) {
        this.minSplitSizePerRack = minSplitSizePerRack;
    }

    public String getInputformat() {
        return this.inputformat;
    }

    public void setInputformat(String inputformat) {
        this.inputformat = inputformat;
    }

    public boolean isUseBucketizedHiveInputFormat() {
        return this.useBucketizedHiveInputFormat;
    }

    public void setUseBucketizedHiveInputFormat(boolean useBucketizedHiveInputFormat) {
        this.useBucketizedHiveInputFormat = useBucketizedHiveInputFormat;
    }

    public void setMapperCannotSpanPartns(boolean mapperCannotSpanPartns) {
        this.mapperCannotSpanPartns = mapperCannotSpanPartns;
    }

    public boolean isMapperCannotSpanPartns() {
        return this.mapperCannotSpanPartns;
    }

    public String getIndexIntermediateFile() {
        return this.indexIntermediateFile;
    }

    public ArrayList<String> getAliases() {
        return new ArrayList<String>(this.aliasToWork.keySet());
    }

    public ArrayList<Operator<?>> getWorks() {
        return new ArrayList(this.aliasToWork.values());
    }

    public ArrayList<Path> getPaths() {
        ArrayList<Path> ret = new ArrayList<Path>();
        ret.addAll(this.pathToAliases.keySet());
        return ret;
    }

    public ArrayList<PartitionDesc> getPartitionDescs() {
        return new ArrayList<PartitionDesc>(this.aliasToPartnInfo.values());
    }

    public Path getTmpHDFSPath() {
        return this.tmpHDFSPath;
    }

    public void setTmpHDFSPath(Path tmpHDFSPath) {
        this.tmpHDFSPath = tmpHDFSPath;
    }

    public Path getTmpPathForPartitionPruning() {
        return this.tmpPathForPartitionPruning;
    }

    public void setTmpPathForPartitionPruning(Path tmpPathForPartitionPruning) {
        this.tmpPathForPartitionPruning = tmpPathForPartitionPruning;
    }

    public void mergingInto(MapWork mapWork) {
        mapWork.useBucketizedHiveInputFormat |= this.useBucketizedHiveInputFormat;
    }

    @Explain(displayName="Path -> Bucketed Columns", explainLevels={Explain.Level.EXTENDED})
    public Map<String, List<BucketingSortingCtx.BucketCol>> getBucketedColsByDirectory() {
        return this.bucketedColsByDirectory;
    }

    @Explain(displayName="Path -> Sorted Columns", explainLevels={Explain.Level.EXTENDED})
    public Map<String, List<BucketingSortingCtx.SortCol>> getSortedColsByDirectory() {
        return this.sortedColsByDirectory;
    }

    public void addIndexIntermediateFile(String fileName) {
        this.indexIntermediateFile = this.indexIntermediateFile == null ? fileName : this.indexIntermediateFile + "," + fileName;
    }

    public int getSamplingType() {
        return this.samplingType;
    }

    public void setSamplingType(int samplingType) {
        this.samplingType = samplingType;
    }

    @Explain(displayName="Sampling", explainLevels={Explain.Level.EXTENDED})
    public String getSamplingTypeString() {
        return this.samplingType == 1 ? "SAMPLING_ON_PREV_MR" : (this.samplingType == 2 ? "SAMPLING_ON_START" : null);
    }

    @Override
    public void configureJobConf(JobConf job) {
        for (PartitionDesc partition : this.aliasToPartnInfo.values()) {
            PlanUtils.configureJobConf(partition.getTableDesc(), job);
        }
        Collection<Operator<?>> mappers = this.aliasToWork.values();
        for (FileSinkOperator fs : OperatorUtils.findOperators(mappers, FileSinkOperator.class)) {
            PlanUtils.configureJobConf(((FileSinkDesc)fs.getConf()).getTableInfo(), job);
        }
    }

    public void setDummyTableScan(boolean dummyTableScan) {
        this.dummyTableScan = dummyTableScan;
    }

    public boolean getDummyTableScan() {
        return this.dummyTableScan;
    }

    public void setEventSourceTableDescMap(Map<String, List<TableDesc>> map) {
        this.eventSourceTableDescMap = map;
    }

    public Map<String, List<TableDesc>> getEventSourceTableDescMap() {
        return this.eventSourceTableDescMap;
    }

    public void setEventSourceColumnNameMap(Map<String, List<String>> map) {
        this.eventSourceColumnNameMap = map;
    }

    public Map<String, List<String>> getEventSourceColumnNameMap() {
        return this.eventSourceColumnNameMap;
    }

    public Map<String, List<String>> getEventSourceColumnTypeMap() {
        return this.eventSourceColumnTypeMap;
    }

    public void setEventSourceColumnTypeMap(Map<String, List<String>> eventSourceColumnTypeMap) {
        this.eventSourceColumnTypeMap = eventSourceColumnTypeMap;
    }

    public Map<String, List<ExprNodeDesc>> getEventSourcePartKeyExprMap() {
        return this.eventSourcePartKeyExprMap;
    }

    public void setEventSourcePartKeyExprMap(Map<String, List<ExprNodeDesc>> map) {
        this.eventSourcePartKeyExprMap = map;
    }

    public void setDoSplitsGrouping(boolean doSplitsGrouping) {
        this.doSplitsGrouping = doSplitsGrouping;
    }

    public boolean getDoSplitsGrouping() {
        return this.doSplitsGrouping;
    }

    public boolean isLeftInputJoin() {
        return this.leftInputJoin;
    }

    public void setLeftInputJoin(boolean leftInputJoin) {
        this.leftInputJoin = leftInputJoin;
    }

    public String[] getBaseSrc() {
        return this.baseSrc;
    }

    public void setBaseSrc(String[] baseSrc) {
        this.baseSrc = baseSrc;
    }

    public List<String> getMapAliases() {
        return this.mapAliases;
    }

    public void setMapAliases(List<String> mapAliases) {
        this.mapAliases = mapAliases;
    }

    public BitSet getIncludedBuckets() {
        return this.includedBuckets != null ? BitSet.valueOf(this.includedBuckets) : null;
    }

    public void setIncludedBuckets(BitSet includedBuckets) {
        this.includedBuckets = includedBuckets == null ? null : includedBuckets.toByteArray();
    }

    public void setVectorizedRowBatch(VectorizedRowBatch vectorizedRowBatch) {
        this.vectorizedRowBatch = vectorizedRowBatch;
    }

    public VectorizedRowBatch getVectorizedRowBatch() {
        return this.vectorizedRowBatch;
    }

    public void setUseVectorizedInputFileFormat(boolean useVectorizedInputFileFormat) {
        this.useVectorizedInputFileFormat = useVectorizedInputFileFormat;
    }

    public boolean getUseVectorizedInputFileFormat() {
        return this.useVectorizedInputFileFormat;
    }

    public void setNotEnabledInputFileFormatReason(VectorizerReason notEnabledInputFileFormatReason) {
        this.notEnabledInputFileFormatReason = notEnabledInputFileFormatReason;
    }

    public VectorizerReason getNotEnabledInputFileFormatReason() {
        return this.notEnabledInputFileFormatReason;
    }

    public void setVectorizationInputFileFormatClassNameSet(Set<String> vectorizationInputFileFormatClassNameSet) {
        this.vectorizationInputFileFormatClassNameSet = vectorizationInputFileFormatClassNameSet;
    }

    public Set<String> getVectorizationInputFileFormatClassNameSet() {
        return this.vectorizationInputFileFormatClassNameSet;
    }

    public void setVectorizationEnabledConditionsMet(ArrayList<String> vectorizationEnabledConditionsMet) {
        this.vectorizationEnabledConditionsMet = vectorizationEnabledConditionsMet == null ? null : VectorizationCondition.addBooleans(vectorizationEnabledConditionsMet, true);
    }

    public List<String> getVectorizationEnabledConditionsMet() {
        return this.vectorizationEnabledConditionsMet;
    }

    public void setVectorizationEnabledConditionsNotMet(List<String> vectorizationEnabledConditionsNotMet) {
        this.vectorizationEnabledConditionsNotMet = vectorizationEnabledConditionsNotMet == null ? null : VectorizationCondition.addBooleans(vectorizationEnabledConditionsNotMet, false);
    }

    public List<String> getVectorizationEnabledConditionsNotMet() {
        return this.vectorizationEnabledConditionsNotMet;
    }

    @Explain(vectorization=Explain.Vectorization.SUMMARY, displayName="Map Vectorization", explainLevels={Explain.Level.DEFAULT, Explain.Level.EXTENDED})
    public MapExplainVectorization getMapExplainVectorization() {
        if (!this.getVectorizationExamined()) {
            return null;
        }
        return new MapExplainVectorization(this);
    }

    public class MapExplainVectorization
    extends BaseWork.BaseExplainVectorization {
        private final MapWork mapWork;

        public MapExplainVectorization(MapWork mapWork) {
            super(mapWork);
            this.mapWork = mapWork;
        }

        @Explain(vectorization=Explain.Vectorization.SUMMARY, displayName="inputFileFormats", explainLevels={Explain.Level.DEFAULT, Explain.Level.EXTENDED})
        public Set<String> inputFileFormats() {
            return this.mapWork.getVectorizationInputFileFormatClassNameSet();
        }

        @Explain(vectorization=Explain.Vectorization.SUMMARY, displayName="enabledConditionsMet", explainLevels={Explain.Level.DEFAULT, Explain.Level.EXTENDED})
        public List<String> enabledConditionsMet() {
            return this.mapWork.getVectorizationEnabledConditionsMet();
        }

        @Explain(vectorization=Explain.Vectorization.SUMMARY, displayName="enabledConditionsNotMet", explainLevels={Explain.Level.DEFAULT, Explain.Level.EXTENDED})
        public List<String> enabledConditionsNotMet() {
            return this.mapWork.getVectorizationEnabledConditionsNotMet();
        }
    }
}

