/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.plan;

import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.io.AcidUtils;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.plan.AbstractOperatorDesc;
import org.apache.hadoop.hive.ql.plan.DynamicPartitionCtx;
import org.apache.hadoop.hive.ql.plan.Explain;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.ListBucketingCtx;
import org.apache.hadoop.hive.ql.plan.OperatorExplainVectorization;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.hive.ql.plan.VectorDesc;

@Explain(displayName="File Output Operator", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
public class FileSinkDesc
extends AbstractOperatorDesc {
    private static final long serialVersionUID = 1L;
    private DPSortState dpSortState;
    private Path dirName;
    private String statsKeyPref;
    private TableDesc tableInfo;
    private boolean compressed;
    private int destTableId;
    private String compressCodec;
    private String compressType;
    private boolean multiFileSpray;
    private boolean temporary;
    private boolean materialization;
    private boolean canBeMerged;
    private int totalFiles;
    private ArrayList<ExprNodeDesc> partitionCols;
    private int numFiles;
    private DynamicPartitionCtx dpCtx;
    private String staticSpec;
    private boolean gatherStats;
    private int indexInTezUnion = -1;
    private transient boolean removedReduceSinkBucketSort;
    private boolean linkedFileSink = false;
    private Path parentDir;
    private transient List<FileSinkDesc> linkedFileSinkDesc;
    private boolean statsReliable;
    private ListBucketingCtx lbCtx;
    private String statsTmpDir;
    private AcidUtils.Operation writeType = AcidUtils.Operation.NOT_ACID;
    private long txnId = 0L;
    private int statementId = -1;
    private transient Table table;
    private Path destPath;
    private boolean isHiveServerQuery;
    private boolean isUsingThriftJDBCBinarySerDe = false;

    public FileSinkDesc() {
    }

    public FileSinkDesc(Path dirName, TableDesc tableInfo, boolean compressed, int destTableId, boolean multiFileSpray, boolean canBeMerged, int numFiles, int totalFiles, ArrayList<ExprNodeDesc> partitionCols, DynamicPartitionCtx dpCtx, Path destPath) {
        this.dirName = dirName;
        this.tableInfo = tableInfo;
        this.compressed = compressed;
        this.destTableId = destTableId;
        this.multiFileSpray = multiFileSpray;
        this.canBeMerged = canBeMerged;
        this.numFiles = numFiles;
        this.totalFiles = totalFiles;
        this.partitionCols = partitionCols;
        this.dpCtx = dpCtx;
        this.dpSortState = DPSortState.NONE;
        this.destPath = destPath;
    }

    public FileSinkDesc(Path dirName, TableDesc tableInfo, boolean compressed) {
        this.dirName = dirName;
        this.tableInfo = tableInfo;
        this.compressed = compressed;
        this.destTableId = 0;
        this.multiFileSpray = false;
        this.canBeMerged = false;
        this.numFiles = 1;
        this.totalFiles = 1;
        this.partitionCols = null;
        this.dpSortState = DPSortState.NONE;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        FileSinkDesc ret = new FileSinkDesc(this.dirName, this.tableInfo, this.compressed, this.destTableId, this.multiFileSpray, this.canBeMerged, this.numFiles, this.totalFiles, this.partitionCols, this.dpCtx, this.destPath);
        ret.setCompressCodec(this.compressCodec);
        ret.setCompressType(this.compressType);
        ret.setGatherStats(this.gatherStats);
        ret.setStaticSpec(this.staticSpec);
        ret.setStatsAggPrefix(this.statsKeyPref);
        ret.setLinkedFileSink(this.linkedFileSink);
        ret.setParentDir(this.parentDir);
        ret.setLinkedFileSinkDesc(this.linkedFileSinkDesc);
        ret.setStatsReliable(this.statsReliable);
        ret.setDpSortState(this.dpSortState);
        ret.setWriteType(this.writeType);
        ret.setTransactionId(this.txnId);
        ret.setStatsTmpDir(this.statsTmpDir);
        return ret;
    }

    public boolean isHiveServerQuery() {
        return this.isHiveServerQuery;
    }

    public void setHiveServerQuery(boolean isHiveServerQuery) {
        this.isHiveServerQuery = isHiveServerQuery;
    }

    public boolean isUsingThriftJDBCBinarySerDe() {
        return this.isUsingThriftJDBCBinarySerDe;
    }

    public void setIsUsingThriftJDBCBinarySerDe(boolean isUsingThriftJDBCBinarySerDe) {
        this.isUsingThriftJDBCBinarySerDe = isUsingThriftJDBCBinarySerDe;
    }

    @Explain(displayName="directory", explainLevels={Explain.Level.EXTENDED})
    public Path getDirName() {
        return this.dirName;
    }

    public void setDirName(Path dirName) {
        this.dirName = dirName;
    }

    public Path getFinalDirName() {
        return this.linkedFileSink ? this.parentDir : this.dirName;
    }

    @Explain(displayName="table", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
    public TableDesc getTableInfo() {
        return this.tableInfo;
    }

    public void setTableInfo(TableDesc tableInfo) {
        this.tableInfo = tableInfo;
    }

    @Explain(displayName="compressed")
    public boolean getCompressed() {
        return this.compressed;
    }

    public void setCompressed(boolean compressed) {
        this.compressed = compressed;
    }

    @Explain(displayName="GlobalTableId", explainLevels={Explain.Level.EXTENDED})
    public int getDestTableId() {
        return this.destTableId;
    }

    public void setDestTableId(int destTableId) {
        this.destTableId = destTableId;
    }

    public String getCompressCodec() {
        return this.compressCodec;
    }

    public void setCompressCodec(String intermediateCompressorCodec) {
        this.compressCodec = intermediateCompressorCodec;
    }

    public String getCompressType() {
        return this.compressType;
    }

    public void setCompressType(String intermediateCompressType) {
        this.compressType = intermediateCompressType;
    }

    @Explain(displayName="MultiFileSpray", explainLevels={Explain.Level.EXTENDED})
    public boolean isMultiFileSpray() {
        return this.multiFileSpray;
    }

    public void setMultiFileSpray(boolean multiFileSpray) {
        this.multiFileSpray = multiFileSpray;
    }

    public boolean isTemporary() {
        return this.temporary;
    }

    public void setTemporary(boolean temporary) {
        this.temporary = temporary;
    }

    public boolean isMaterialization() {
        return this.materialization;
    }

    public void setMaterialization(boolean materialization) {
        this.materialization = materialization;
    }

    public boolean canBeMerged() {
        return this.canBeMerged;
    }

    public void setCanBeMerged(boolean canBeMerged) {
        this.canBeMerged = canBeMerged;
    }

    @Explain(displayName="TotalFiles", explainLevels={Explain.Level.EXTENDED})
    public int getTotalFiles() {
        return this.totalFiles;
    }

    public void setTotalFiles(int totalFiles) {
        this.totalFiles = totalFiles;
    }

    public ArrayList<ExprNodeDesc> getPartitionCols() {
        return this.partitionCols;
    }

    public void setPartitionCols(ArrayList<ExprNodeDesc> partitionCols) {
        this.partitionCols = partitionCols;
    }

    @Explain(displayName="NumFilesPerFileSink", explainLevels={Explain.Level.EXTENDED})
    public int getNumFiles() {
        return this.numFiles;
    }

    public void setNumFiles(int numFiles) {
        this.numFiles = numFiles;
    }

    public void setDynPartCtx(DynamicPartitionCtx dpc) {
        this.dpCtx = dpc;
    }

    public DynamicPartitionCtx getDynPartCtx() {
        return this.dpCtx;
    }

    public void setStaticSpec(String staticSpec) {
        this.staticSpec = staticSpec;
    }

    @Explain(displayName="Static Partition Specification", explainLevels={Explain.Level.EXTENDED})
    public String getStaticSpec() {
        return this.staticSpec;
    }

    public void setGatherStats(boolean gatherStats) {
        this.gatherStats = gatherStats;
    }

    @Explain(displayName="GatherStats", explainLevels={Explain.Level.EXTENDED})
    public boolean isGatherStats() {
        return this.gatherStats;
    }

    @Explain(displayName="Stats Publishing Key Prefix", explainLevels={Explain.Level.EXTENDED})
    public String getStatsAggPrefix() {
        return this.statsKeyPref;
    }

    public void setStatsAggPrefix(String k) {
        this.statsKeyPref = k.endsWith("/") ? k : k + "/";
    }

    public boolean isLinkedFileSink() {
        return this.linkedFileSink;
    }

    public void setLinkedFileSink(boolean linkedFileSink) {
        this.linkedFileSink = linkedFileSink;
    }

    public Path getParentDir() {
        return this.parentDir;
    }

    public void setParentDir(Path parentDir) {
        this.parentDir = parentDir;
    }

    public boolean isStatsReliable() {
        return this.statsReliable;
    }

    public void setStatsReliable(boolean statsReliable) {
        this.statsReliable = statsReliable;
    }

    public ListBucketingCtx getLbCtx() {
        return this.lbCtx;
    }

    public void setLbCtx(ListBucketingCtx lbCtx) {
        this.lbCtx = lbCtx;
    }

    public List<FileSinkDesc> getLinkedFileSinkDesc() {
        return this.linkedFileSinkDesc;
    }

    public void setLinkedFileSinkDesc(List<FileSinkDesc> linkedFileSinkDesc) {
        this.linkedFileSinkDesc = linkedFileSinkDesc;
    }

    public boolean isRemovedReduceSinkBucketSort() {
        return this.removedReduceSinkBucketSort;
    }

    public void setRemovedReduceSinkBucketSort(boolean removedReduceSinkBucketSort) {
        this.removedReduceSinkBucketSort = removedReduceSinkBucketSort;
    }

    public DPSortState getDpSortState() {
        return this.dpSortState;
    }

    public void setDpSortState(DPSortState dpSortState) {
        this.dpSortState = dpSortState;
    }

    public void setWriteType(AcidUtils.Operation type) {
        this.writeType = type;
    }

    public AcidUtils.Operation getWriteType() {
        return this.writeType;
    }

    public void setTransactionId(long id) {
        this.txnId = id;
    }

    public long getTransactionId() {
        return this.txnId;
    }

    public void setStatementId(int id) {
        this.statementId = id;
    }

    public int getStatementId() {
        return this.statementId;
    }

    public Path getDestPath() {
        return this.destPath;
    }

    public Table getTable() {
        return this.table;
    }

    public void setTable(Table table) {
        this.table = table;
    }

    public String getStatsTmpDir() {
        return this.statsTmpDir;
    }

    public void setStatsTmpDir(String statsCollectionTempDir) {
        this.statsTmpDir = statsCollectionTempDir;
    }

    public int getIndexInTezUnion() {
        return this.indexInTezUnion;
    }

    public void setIndexInTezUnion(int indexInTezUnion) {
        this.indexInTezUnion = indexInTezUnion;
    }

    @Explain(vectorization=Explain.Vectorization.OPERATOR, displayName="File Sink Vectorization", explainLevels={Explain.Level.DEFAULT, Explain.Level.EXTENDED})
    public FileSinkOperatorExplainVectorization getFileSinkVectorization() {
        if (this.vectorDesc == null) {
            return null;
        }
        return new FileSinkOperatorExplainVectorization(this.vectorDesc);
    }

    public class FileSinkOperatorExplainVectorization
    extends OperatorExplainVectorization {
        public FileSinkOperatorExplainVectorization(VectorDesc vectorDesc) {
            super(vectorDesc, false);
        }
    }

    public static enum DPSortState {
        NONE,
        PARTITION_SORTED,
        PARTITION_BUCKET_SORTED;

    }
}

