/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.antlr.runtime.tree.Tree;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.ql.Context;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.QueryState;
import org.apache.hadoop.hive.ql.hooks.Entity;
import org.apache.hadoop.hive.ql.hooks.ReadEntity;
import org.apache.hadoop.hive.ql.hooks.WriteEntity;
import org.apache.hadoop.hive.ql.io.AcidUtils;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.HiveUtils;
import org.apache.hadoop.hive.ql.metadata.InvalidTableException;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.metadata.VirtualColumn;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.ColumnAccessInfo;
import org.apache.hadoop.hive.ql.parse.ParseException;
import org.apache.hadoop.hive.ql.parse.ParseUtils;
import org.apache.hadoop.hive.ql.parse.SemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.session.SessionState;

public class UpdateDeleteSemanticAnalyzer
extends SemanticAnalyzer {
    boolean useSuper = false;

    public UpdateDeleteSemanticAnalyzer(QueryState queryState) throws SemanticException {
        super(queryState);
    }

    @Override
    public void analyzeInternal(ASTNode tree) throws SemanticException {
        if (!this.useSuper) {
            if (!SessionState.get().getTxnMgr().supportsAcid()) {
                throw new SemanticException(ErrorMsg.ACID_OP_ON_NONACID_TXNMGR.getMsg());
            }
            switch (tree.getToken().getType()) {
                case 733: {
                    this.analyzeDelete(tree);
                    return;
                }
                case 993: {
                    this.analyzeUpdate(tree);
                    return;
                }
            }
            throw new RuntimeException("Asked to parse token " + tree.getName() + " in UpdateDeleteSemanticAnalyzer");
        }
        super.analyzeInternal(tree);
    }

    @Override
    protected boolean updating() {
        return this.ctx.getAcidOperation() == AcidUtils.Operation.UPDATE;
    }

    @Override
    protected boolean deleting() {
        return this.ctx.getAcidOperation() == AcidUtils.Operation.DELETE;
    }

    private void analyzeUpdate(ASTNode tree) throws SemanticException {
        this.ctx.setAcidOperation(AcidUtils.Operation.UPDATE);
        this.reparseAndSuperAnalyze(tree);
    }

    private void analyzeDelete(ASTNode tree) throws SemanticException {
        this.ctx.setAcidOperation(AcidUtils.Operation.DELETE);
        this.reparseAndSuperAnalyze(tree);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reparseAndSuperAnalyze(ASTNode tree) throws SemanticException {
        ASTNode rewrittenTree;
        Context rewrittenCtx;
        int whereIndex;
        Table mTable;
        List children = tree.getChildren();
        ASTNode tabName = (ASTNode)children.get(0);
        assert (tabName.getToken().getType() == 970) : "Expected tablename as first child of " + this.operation() + " but found " + tabName.getName();
        String[] tableName = UpdateDeleteSemanticAnalyzer.getQualifiedTableName(tabName);
        StringBuilder rewrittenQueryStr = new StringBuilder();
        try {
            mTable = this.db.getTable(tableName[0], tableName[1]);
        }
        catch (InvalidTableException e) {
            this.LOG.error("Failed to find table " + UpdateDeleteSemanticAnalyzer.getDotName(tableName) + " got exception " + e.getMessage());
            throw new SemanticException(ErrorMsg.INVALID_TABLE.getMsg(UpdateDeleteSemanticAnalyzer.getDotName(tableName)), e);
        }
        catch (HiveException e) {
            this.LOG.error("Failed to find table " + UpdateDeleteSemanticAnalyzer.getDotName(tableName) + " got exception " + e.getMessage());
            throw new SemanticException(e.getMessage(), e);
        }
        List<FieldSchema> partCols = mTable.getPartCols();
        List<String> bucketingCols = mTable.getBucketCols();
        rewrittenQueryStr.append("insert into table ");
        rewrittenQueryStr.append(UpdateDeleteSemanticAnalyzer.getDotName(new String[]{HiveUtils.unparseIdentifier(tableName[0], this.conf), HiveUtils.unparseIdentifier(tableName[1], this.conf)}));
        if (partCols != null && partCols.size() > 0) {
            rewrittenQueryStr.append(" partition (");
            boolean first = true;
            for (FieldSchema fschema : partCols) {
                if (first) {
                    first = false;
                } else {
                    rewrittenQueryStr.append(", ");
                }
                rewrittenQueryStr.append(HiveUtils.unparseIdentifier(fschema.getName(), this.conf));
            }
            rewrittenQueryStr.append(")");
        }
        rewrittenQueryStr.append(" select ROW__ID");
        HashMap<Integer, ASTNode> setColExprs = null;
        LinkedHashMap<String, ASTNode> setCols = null;
        LinkedHashSet<String> setRCols = new LinkedHashSet<String>();
        if (this.updating()) {
            assert (children.size() >= 2) : "Expected update token to have at least two children";
            ASTNode setClause = (ASTNode)children.get(1);
            assert (setClause.getToken().getType() == 902) : "Expected second child of update token to be set token";
            List assignments = setClause.getChildren();
            setCols = new LinkedHashMap<String, ASTNode>(assignments.size());
            setColExprs = new HashMap<Integer, ASTNode>(assignments.size());
            for (Node a : assignments) {
                ASTNode assignment = (ASTNode)a;
                assert (assignment.getToken().getType() == 21) : "Expected set assignments to use equals operator but found " + assignment.getName();
                ASTNode tableOrColTok = (ASTNode)((ArrayList)assignment.getChildren()).get(0);
                assert (tableOrColTok.getToken().getType() == 967) : "Expected left side of assignment to be table or column";
                ASTNode colName = (ASTNode)((ArrayList)tableOrColTok.getChildren()).get(0);
                assert (colName.getToken().getType() == 27) : "Expected column name";
                this.addSetRCols((ASTNode)((ArrayList)assignment.getChildren()).get(1), setRCols);
                String string = UpdateDeleteSemanticAnalyzer.normalizeColName(colName.getText());
                if (partCols != null) {
                    for (FieldSchema fschema : partCols) {
                        if (!fschema.getName().equalsIgnoreCase(string)) continue;
                        throw new SemanticException(ErrorMsg.UPDATE_CANNOT_UPDATE_PART_VALUE.getMsg());
                    }
                }
                if (bucketingCols != null && bucketingCols.contains(string)) {
                    throw new SemanticException(ErrorMsg.UPDATE_CANNOT_UPDATE_BUCKET_VALUE, string);
                }
                setCols.put(string, (ASTNode)((ArrayList)assignment.getChildren()).get(1));
            }
            List<FieldSchema> nonPartCols = mTable.getCols();
            for (int i = 0; i < nonPartCols.size(); ++i) {
                rewrittenQueryStr.append(',');
                String name = nonPartCols.get(i).getName();
                ASTNode setCol = (ASTNode)setCols.get(name);
                rewrittenQueryStr.append(HiveUtils.unparseIdentifier(name, this.conf));
                if (setCol == null) continue;
                setColExprs.put(i + 1, setCol);
            }
        }
        if (partCols != null) {
            for (FieldSchema fschema : partCols) {
                rewrittenQueryStr.append(", ");
                rewrittenQueryStr.append(HiveUtils.unparseIdentifier(fschema.getName(), this.conf));
            }
        }
        rewrittenQueryStr.append(" from ");
        rewrittenQueryStr.append(UpdateDeleteSemanticAnalyzer.getDotName(new String[]{HiveUtils.unparseIdentifier(tableName[0], this.conf), HiveUtils.unparseIdentifier(tableName[1], this.conf)}));
        ASTNode where = null;
        int n = whereIndex = this.deleting() ? 1 : 2;
        if (children.size() > whereIndex) {
            where = (ASTNode)children.get(whereIndex);
            assert (where.getToken().getType() == 1005) : "Expected where clause, but found " + where.getName();
        }
        rewrittenQueryStr.append(" sort by ROW__ID ");
        try {
            HiveConf.setVar(this.conf, HiveConf.ConfVars.DYNAMICPARTITIONINGMODE, "nonstrict");
            rewrittenCtx = new Context(this.conf);
        }
        catch (IOException e) {
            throw new SemanticException(ErrorMsg.UPDATEDELETE_IO_ERROR.getMsg());
        }
        rewrittenCtx.setCmd(rewrittenQueryStr.toString());
        rewrittenCtx.setAcidOperation(this.ctx.getAcidOperation());
        try {
            this.LOG.info("Going to reparse " + this.operation() + " as <" + rewrittenQueryStr.toString() + ">");
            rewrittenTree = ParseUtils.parse(rewrittenQueryStr.toString(), rewrittenCtx);
        }
        catch (ParseException e) {
            throw new SemanticException(ErrorMsg.UPDATEDELETE_PARSE_ERROR.getMsg(), e);
        }
        ASTNode rewrittenInsert = (ASTNode)((ArrayList)rewrittenTree.getChildren()).get(1);
        assert (rewrittenInsert.getToken().getType() == 785) : "Expected TOK_INSERT as second child of TOK_QUERY but found " + rewrittenInsert.getName();
        if (where != null) {
            ASTNode sortBy = (ASTNode)((ArrayList)rewrittenInsert.getChildren()).get(2);
            assert (sortBy.getToken().getType() == 927) : "Expected TOK_SORTBY to be first child of TOK_SELECT, but found " + sortBy.getName();
            rewrittenInsert.addChild((Tree)sortBy);
            rewrittenInsert.setChild(2, (Tree)where);
        }
        if (this.updating() && setColExprs != null) {
            Iterator rewrittenSelect = (ASTNode)((ArrayList)rewrittenInsert.getChildren()).get(1);
            assert (rewrittenSelect.getToken().getType() == 893) : "Expected TOK_SELECT as second child of TOK_INSERT but found " + ((ASTNode)((Object)rewrittenSelect)).getName();
            for (Map.Entry entry : setColExprs.entrySet()) {
                ASTNode selExpr = (ASTNode)((ArrayList)((ASTNode)((Object)rewrittenSelect)).getChildren()).get((Integer)entry.getKey());
                assert (selExpr.getToken().getType() == 895) : "Expected child of TOK_SELECT to be TOK_SELEXPR but was " + selExpr.getName();
                selExpr.setChild(0, (Tree)entry.getValue());
            }
        }
        try {
            this.useSuper = true;
            super.analyze(rewrittenTree, rewrittenCtx);
        }
        finally {
            this.useSuper = false;
        }
        for (ReadEntity input : this.inputs) {
            if (!this.isWritten(input)) continue;
            input.setUpdateOrDelete(true);
        }
        if (this.inputIsPartitioned(this.inputs)) {
            this.outputs.clear();
            for (ReadEntity input : this.inputs) {
                if (input.getTyp() != Entity.Type.PARTITION) continue;
                WriteEntity.WriteType writeType = this.deleting() ? WriteEntity.WriteType.DELETE : WriteEntity.WriteType.UPDATE;
                this.outputs.add(new WriteEntity(input.getPartition(), writeType));
            }
        } else {
            for (WriteEntity output : this.outputs) {
                output.setWriteType(this.deleting() ? WriteEntity.WriteType.DELETE : WriteEntity.WriteType.UPDATE);
            }
        }
        if (this.updating()) {
            ColumnAccessInfo cai = new ColumnAccessInfo();
            for (String string : setCols.keySet()) {
                cai.add(Table.getCompleteName(mTable.getDbName(), mTable.getTableName()), string);
            }
            this.setUpdateColumnAccessInfo(cai);
            for (String string : setRCols) {
                if (this.columnAccessInfo == null) continue;
                this.columnAccessInfo.add(Table.getCompleteName(mTable.getDbName(), mTable.getTableName()), string);
            }
        }
        if (this.columnAccessInfo != null) {
            this.columnAccessInfo.stripVirtualColumn(VirtualColumn.ROWID);
        }
    }

    private boolean isWritten(Entity readEntity) {
        for (Entity writeEntity : this.outputs) {
            if (!writeEntity.toString().equalsIgnoreCase(readEntity.toString())) continue;
            return true;
        }
        return false;
    }

    private String operation() {
        if (this.updating()) {
            return "update";
        }
        if (this.deleting()) {
            return "delete";
        }
        throw new IllegalStateException("UpdateDeleteSemanticAnalyzer neither updating nor deleting, operation not known.");
    }

    private boolean inputIsPartitioned(Set<ReadEntity> inputs) {
        for (ReadEntity re : inputs) {
            if (re.getTyp() != Entity.Type.PARTITION) continue;
            return true;
        }
        return false;
    }

    private void addSetRCols(ASTNode node, Set<String> setRCols) {
        if (node.getToken().getType() == 967) {
            ASTNode colName = (ASTNode)((ArrayList)node.getChildren()).get(0);
            assert (colName.getToken().getType() == 27) : "Expected column name";
            setRCols.add(UpdateDeleteSemanticAnalyzer.normalizeColName(colName.getText()));
        } else if (node.getChildren() != null) {
            for (Node n : node.getChildren()) {
                this.addSetRCols((ASTNode)n, setRCols);
            }
        }
    }

    private static String normalizeColName(String colName) {
        return colName.toLowerCase();
    }
}

