/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse;

import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.Index;
import org.apache.hadoop.hive.ql.Driver;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.hooks.ReadEntity;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.optimizer.IndexUtils;
import org.apache.hadoop.hive.ql.plan.LoadTableDesc;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.hive.ql.session.LineageState;

public class IndexUpdater {
    private List<LoadTableDesc> loadTableWork;
    private HiveConf conf;
    private Hive hive;
    private List<Task<? extends Serializable>> tasks;
    private Set<ReadEntity> inputs;
    private LineageState lineageState;

    public IndexUpdater(List<LoadTableDesc> loadTableWork, Set<ReadEntity> inputs, Configuration conf, LineageState lineageState) {
        this.loadTableWork = loadTableWork;
        this.inputs = inputs;
        this.conf = new HiveConf(conf, IndexUpdater.class);
        this.lineageState = lineageState;
        this.tasks = new LinkedList<Task<? extends Serializable>>();
    }

    public IndexUpdater(LoadTableDesc loadTableWork, Set<ReadEntity> inputs, Configuration conf) {
        this.loadTableWork = new LinkedList<LoadTableDesc>();
        this.loadTableWork.add(loadTableWork);
        this.conf = new HiveConf(conf, IndexUpdater.class);
        this.tasks = new LinkedList<Task<? extends Serializable>>();
        this.inputs = inputs;
    }

    public List<Task<? extends Serializable>> generateUpdateTasks() throws HiveException {
        this.hive = Hive.get(this.conf);
        for (LoadTableDesc ltd : this.loadTableWork) {
            TableDesc td = ltd.getTable();
            Table srcTable = this.hive.getTable(td.getTableName());
            List<Index> tblIndexes = IndexUtils.getAllIndexes(srcTable, (short)-1);
            Map<String, String> partSpec = ltd.getPartitionSpec();
            if (partSpec == null || partSpec.size() == 0) {
                this.doIndexUpdate(tblIndexes);
                continue;
            }
            this.doIndexUpdate(tblIndexes, partSpec);
        }
        return this.tasks;
    }

    private void doIndexUpdate(List<Index> tblIndexes) throws HiveException {
        Driver driver = new Driver(this.conf, this.lineageState);
        for (Index idx : tblIndexes) {
            StringBuilder sb = new StringBuilder();
            sb.append("ALTER INDEX ");
            sb.append(idx.getIndexName());
            sb.append(" ON ");
            sb.append(idx.getDbName()).append('.');
            sb.append(idx.getOrigTableName());
            sb.append(" REBUILD");
            driver.compile(sb.toString(), false);
            this.tasks.addAll(driver.getPlan().getRootTasks());
            this.inputs.addAll(driver.getPlan().getInputs());
        }
    }

    private void doIndexUpdate(List<Index> tblIndexes, Map<String, String> partSpec) throws HiveException {
        for (Index index : tblIndexes) {
            if (!this.containsPartition(index, partSpec)) continue;
            this.doIndexUpdate(index, partSpec);
        }
    }

    private void doIndexUpdate(Index index, Map<String, String> partSpec) throws HiveException {
        StringBuilder ps = new StringBuilder();
        boolean first = true;
        ps.append("(");
        for (String key : partSpec.keySet()) {
            if (!first) {
                ps.append(", ");
            } else {
                first = false;
            }
            ps.append(key);
            ps.append("=");
            ps.append(partSpec.get(key));
        }
        ps.append(")");
        StringBuilder sb = new StringBuilder();
        sb.append("ALTER INDEX ");
        sb.append(index.getIndexName());
        sb.append(" ON ");
        sb.append(index.getDbName()).append('.');
        sb.append(index.getOrigTableName());
        sb.append(" PARTITION ");
        sb.append(ps.toString());
        sb.append(" REBUILD");
        Driver driver = new Driver(this.conf, this.lineageState);
        driver.compile(sb.toString(), false);
        this.tasks.addAll(driver.getPlan().getRootTasks());
        this.inputs.addAll(driver.getPlan().getInputs());
    }

    private boolean containsPartition(Index index, Map<String, String> partSpec) throws HiveException {
        String[] qualified = Utilities.getDbTableName(index.getDbName(), index.getIndexTableName());
        Table indexTable = this.hive.getTable(qualified[0], qualified[1]);
        List<Partition> parts = this.hive.getPartitions(indexTable, partSpec);
        return parts == null || parts.size() == 0;
    }
}

