/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions.gen;

import java.util.Arrays;
import org.apache.hadoop.hive.ql.exec.vector.BytesColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.StringExpr;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.metadata.HiveException;

public abstract class StringGroupColNotEqualStringGroupScalarBase
extends VectorExpression {
    private static final long serialVersionUID = 1L;
    protected int colNum;
    protected byte[] value;
    protected int outputColumn;

    @Override
    public void evaluate(VectorizedRowBatch batch) throws HiveException {
        block13: {
            int[] start;
            int[] length;
            byte[][] vector;
            boolean[] outputIsNull;
            boolean[] inputIsNull;
            int[] sel;
            int n;
            block14: {
                BytesColumnVector inputColVector;
                block12: {
                    n = batch.size;
                    if (n == 0) {
                        return;
                    }
                    if (this.childExpressions != null) {
                        super.evaluateChildren(batch);
                    }
                    inputColVector = (BytesColumnVector)batch.cols[this.colNum];
                    LongColumnVector outputColVector = (LongColumnVector)batch.cols[this.outputColumn];
                    sel = batch.selected;
                    inputIsNull = inputColVector.isNull;
                    outputIsNull = outputColVector.isNull;
                    vector = inputColVector.vector;
                    length = inputColVector.length;
                    start = inputColVector.start;
                    long[] outVector = outputColVector.vector;
                    outputColVector.isRepeating = false;
                    if (!inputColVector.noNulls) break block12;
                    if (inputColVector.isRepeating) {
                        outputColVector.isRepeating = true;
                        outputIsNull[0] = false;
                        outVector[0] = !StringExpr.equal(vector[0], start[0], length[0], this.value, 0, this.value.length) ? 1L : 0L;
                    } else if (batch.selectedInUse) {
                        for (int j = 0; j != n; ++j) {
                            int i = sel[j];
                            outputIsNull[i] = false;
                            outVector[i] = !StringExpr.equal(vector[i], start[i], length[i], this.value, 0, this.value.length) ? 1L : 0L;
                        }
                    } else {
                        Arrays.fill(outputIsNull, 0, n, false);
                        for (int i = 0; i != n; ++i) {
                            outVector[i] = !StringExpr.equal(vector[i], start[i], length[i], this.value, 0, this.value.length) ? 1L : 0L;
                        }
                    }
                    break block13;
                }
                outputColVector.noNulls = false;
                if (!inputColVector.isRepeating) break block14;
                outputColVector.isRepeating = true;
                outputIsNull[0] = inputIsNull[0];
                if (inputIsNull[0]) break block13;
                outVector[0] = !StringExpr.equal(vector[0], start[0], length[0], this.value, 0, this.value.length) ? 1L : 0L;
                break block13;
            }
            if (batch.selectedInUse) {
                for (int j = 0; j != n; ++j) {
                    int i = sel[j];
                    outputIsNull[i] = inputIsNull[i];
                    if (inputIsNull[i]) continue;
                    outVector[i] = !StringExpr.equal(vector[i], start[i], length[i], this.value, 0, this.value.length) ? 1L : 0L;
                }
            } else {
                System.arraycopy(inputIsNull, 0, outputIsNull, 0, n);
                for (int i = 0; i != n; ++i) {
                    outputIsNull[i] = inputIsNull[i];
                    if (inputIsNull[i]) continue;
                    outVector[i] = !StringExpr.equal(vector[i], start[i], length[i], this.value, 0, this.value.length) ? 1L : 0L;
                }
            }
        }
    }

    @Override
    public int getOutputColumn() {
        return this.outputColumn;
    }

    public int getColNum() {
        return this.colNum;
    }

    public void setColNum(int colNum) {
        this.colNum = colNum;
    }

    public byte[] getValue() {
        return this.value;
    }

    public void setValue(byte[] value) {
        this.value = value;
    }

    public void setOutputColumn(int outputColumn) {
        this.outputColumn = outputColumn;
    }

    @Override
    public String vectorExpressionParameters() {
        return "col " + this.colNum + ", val " + StringGroupColNotEqualStringGroupScalarBase.displayUtf8Bytes(this.value);
    }
}

