/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions;

import org.apache.hadoop.hive.ql.exec.vector.DoubleColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorExpressionDescriptor;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.metadata.HiveException;

public class IfExprDoubleColumnDoubleColumn
extends VectorExpression {
    private static final long serialVersionUID = 1L;
    private int arg1Column;
    private int arg2Column;
    private int arg3Column;
    private int outputColumn;

    public IfExprDoubleColumnDoubleColumn(int arg1Column, int arg2Column, int arg3Column, int outputColumn) {
        this.arg1Column = arg1Column;
        this.arg2Column = arg2Column;
        this.arg3Column = arg3Column;
        this.outputColumn = outputColumn;
    }

    public IfExprDoubleColumnDoubleColumn() {
    }

    @Override
    public void evaluate(VectorizedRowBatch batch) throws HiveException {
        if (this.childExpressions != null) {
            super.evaluateChildren(batch);
        }
        LongColumnVector arg1ColVector = (LongColumnVector)batch.cols[this.arg1Column];
        DoubleColumnVector arg2ColVector = (DoubleColumnVector)batch.cols[this.arg2Column];
        DoubleColumnVector arg3ColVector = (DoubleColumnVector)batch.cols[this.arg3Column];
        DoubleColumnVector outputColVector = (DoubleColumnVector)batch.cols[this.outputColumn];
        int[] sel = batch.selected;
        boolean[] outputIsNull = outputColVector.isNull;
        int n = batch.size;
        long[] vector1 = arg1ColVector.vector;
        double[] vector2 = arg2ColVector.vector;
        double[] vector3 = arg3ColVector.vector;
        double[] outputVector = outputColVector.vector;
        if (n == 0) {
            return;
        }
        outputColVector.isRepeating = false;
        if (arg1ColVector.isRepeating) {
            if ((arg1ColVector.noNulls || !arg1ColVector.isNull[0]) && vector1[0] == 1L) {
                arg2ColVector.copySelected(batch.selectedInUse, sel, n, outputColVector);
            } else {
                arg3ColVector.copySelected(batch.selectedInUse, sel, n, outputColVector);
            }
            return;
        }
        arg2ColVector.flatten(batch.selectedInUse, sel, n);
        arg3ColVector.flatten(batch.selectedInUse, sel, n);
        if (arg1ColVector.noNulls) {
            outputColVector.noNulls = false;
            if (batch.selectedInUse) {
                for (int j = 0; j != n; ++j) {
                    int i = sel[j];
                    outputVector[i] = vector1[i] == 1L ? vector2[i] : vector3[i];
                    outputIsNull[i] = vector1[i] == 1L ? arg2ColVector.isNull[i] : arg3ColVector.isNull[i];
                }
            } else {
                for (int i = 0; i != n; ++i) {
                    outputVector[i] = vector1[i] == 1L ? vector2[i] : vector3[i];
                    outputIsNull[i] = vector1[i] == 1L ? arg2ColVector.isNull[i] : arg3ColVector.isNull[i];
                }
            }
        } else {
            outputColVector.noNulls = false;
            if (batch.selectedInUse) {
                for (int j = 0; j != n; ++j) {
                    int i = sel[j];
                    outputVector[i] = !arg1ColVector.isNull[i] && vector1[i] == 1L ? vector2[i] : vector3[i];
                    outputIsNull[i] = !arg1ColVector.isNull[i] && vector1[i] == 1L ? arg2ColVector.isNull[i] : arg3ColVector.isNull[i];
                }
            } else {
                for (int i = 0; i != n; ++i) {
                    outputVector[i] = !arg1ColVector.isNull[i] && vector1[i] == 1L ? vector2[i] : vector3[i];
                    outputIsNull[i] = !arg1ColVector.isNull[i] && vector1[i] == 1L ? arg2ColVector.isNull[i] : arg3ColVector.isNull[i];
                }
            }
        }
        arg2ColVector.unFlatten();
        arg3ColVector.unFlatten();
    }

    @Override
    public int getOutputColumn() {
        return this.outputColumn;
    }

    public int getArg1Column() {
        return this.arg1Column;
    }

    public void setArg1Column(int colNum) {
        this.arg1Column = colNum;
    }

    public int getArg2Column() {
        return this.arg2Column;
    }

    public void setArg2Column(int colNum) {
        this.arg2Column = colNum;
    }

    public int getArg3Column() {
        return this.arg3Column;
    }

    public void setArg3Column(int colNum) {
        this.arg3Column = colNum;
    }

    public void setOutputColumn(int outputColumn) {
        this.outputColumn = outputColumn;
    }

    @Override
    public String vectorExpressionParameters() {
        return "col " + this.arg1Column + ", col " + this.arg2Column + ", col " + this.arg3Column;
    }

    @Override
    public VectorExpressionDescriptor.Descriptor getDescriptor() {
        return new VectorExpressionDescriptor.Builder().setMode(VectorExpressionDescriptor.Mode.PROJECTION).setNumArguments(3).setArgumentTypes(VectorExpressionDescriptor.ArgumentType.getType("long"), VectorExpressionDescriptor.ArgumentType.getType("double"), VectorExpressionDescriptor.ArgumentType.getType("double")).setInputExpressionTypes(VectorExpressionDescriptor.InputExpressionType.COLUMN, VectorExpressionDescriptor.InputExpressionType.COLUMN, VectorExpressionDescriptor.InputExpressionType.COLUMN).build();
    }
}

