/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions;

import org.apache.hadoop.hive.ql.exec.vector.VectorExpressionDescriptor;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.metadata.HiveException;

public class IdentityExpression
extends VectorExpression {
    private static final long serialVersionUID = 1L;
    private int colNum = -1;

    public IdentityExpression() {
    }

    public IdentityExpression(int colNum) {
        this.colNum = colNum;
    }

    @Override
    public void evaluate(VectorizedRowBatch batch) throws HiveException {
        if (this.childExpressions != null) {
            this.evaluateChildren(batch);
        }
    }

    public static boolean isColumnOnly(VectorExpression ve) {
        if (ve instanceof IdentityExpression) {
            IdentityExpression identityExpression = (IdentityExpression)ve;
            return identityExpression.childExpressions == null;
        }
        return false;
    }

    @Override
    public int getOutputColumn() {
        return this.colNum;
    }

    public int getColNum() {
        return this.getOutputColumn();
    }

    public void setColNum(int colNum) {
        this.colNum = colNum;
    }

    @Override
    public String vectorExpressionParameters() {
        return "col " + this.colNum;
    }

    @Override
    public VectorExpressionDescriptor.Descriptor getDescriptor() {
        return new VectorExpressionDescriptor.Builder().build();
    }
}

