/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.datasource;

import com.google.common.collect.Iterables;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.shims.ShimLoader;

public interface DataSourceProvider {
    public DataSource create(Configuration var1) throws SQLException;

    public boolean mayReturnClosedConnection();

    public String getPoolingType();

    public static Properties getPrefixedProperties(Configuration hdpConfig, String factoryPrefix) {
        Properties dataSourceProps = new Properties();
        Iterables.filter(hdpConfig, entry -> entry.getKey() != null && ((String)entry.getKey()).startsWith(factoryPrefix)).forEach(entry -> dataSourceProps.put(entry.getKey(), entry.getValue()));
        return dataSourceProps;
    }

    public static String getMetastoreJdbcUser(Configuration conf) {
        return HiveConf.getVar(conf, HiveConf.ConfVars.METASTORE_CONNECTION_USER_NAME);
    }

    public static String getMetastoreJdbcPasswd(Configuration conf) throws SQLException {
        try {
            return ShimLoader.getHadoopShims().getPassword(conf, HiveConf.ConfVars.METASTOREPWD.varname);
        }
        catch (IOException err) {
            throw new SQLException("Error getting metastore password", err);
        }
    }

    public static String getMetastoreJdbcDriverUrl(Configuration conf) throws SQLException {
        return HiveConf.getVar(conf, HiveConf.ConfVars.METASTORECONNECTURLKEY);
    }
}

