/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security;

import java.net.URI;
import java.net.URISyntaxException;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.security.alias.JavaKeyStoreProvider;

public class ProviderUtils {
    public static Path unnestUri(URI nestedUri) {
        String[] parts = nestedUri.getAuthority().split("@", 2);
        StringBuilder result = new StringBuilder(parts[0]);
        result.append("://");
        if (parts.length == 2) {
            result.append(parts[1]);
        }
        result.append(nestedUri.getPath());
        if (nestedUri.getQuery() != null) {
            result.append("?");
            result.append(nestedUri.getQuery());
        }
        if (nestedUri.getFragment() != null) {
            result.append("#");
            result.append(nestedUri.getFragment());
        }
        return new Path(result.toString());
    }

    public static URI nestURIForLocalJavaKeyStoreProvider(URI localFile) throws URISyntaxException {
        if (!"file".equals(localFile.getScheme())) {
            throw new IllegalArgumentException("passed URI had a scheme other than file.");
        }
        if (localFile.getAuthority() != null) {
            throw new IllegalArgumentException("passed URI must not have an authority component. For non-local keystores, please use " + JavaKeyStoreProvider.class.getName());
        }
        return new URI("localjceks", "//file" + localFile.getSchemeSpecificPart(), localFile.getFragment());
    }
}

