/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.giraph.hive.schema;

import com.facebook.giraph.hive.common.HiveMetastores;
import com.facebook.giraph.hive.common.HiveTableName;
import com.facebook.giraph.hive.common.Writables;
import com.facebook.giraph.hive.schema.HiveTableSchema;
import com.facebook.giraph.hive.schema.HiveTableSchemaAware;
import com.facebook.giraph.hive.schema.HiveTableSchemaImpl;
import com.google.common.base.Function;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.api.ThriftHiveMetastore;
import org.apache.log4j.Logger;

public class HiveTableSchemas {
    public static final String PROFILE_KEY_PREFIX = "hive.io.schema.profile.";
    private static final Logger LOG = Logger.getLogger(HiveTableSchemas.class);

    protected HiveTableSchemas() {
    }

    public static void configure(Object obj, HiveTableSchema schema) {
        if (obj instanceof HiveTableSchemaAware) {
            ((HiveTableSchemaAware)obj).setTableSchema(schema);
        }
    }

    public static Function<String, Integer> schemaLookupFunc(final HiveTableSchema tableSchema) {
        return new Function<String, Integer>(){

            public Integer apply(String input) {
                return tableSchema.positionOf(input);
            }
        };
    }

    public static HiveTableSchema get(Configuration conf, String profile) {
        String key = HiveTableSchemas.profileKey(profile);
        String value = conf.get(key);
        if (value == null) {
            throw new NullPointerException("No HiveTableSchema with key " + key + " found");
        }
        HiveTableSchemaImpl hiveTableSchema = new HiveTableSchemaImpl();
        Writables.readFieldsFromEncodedStr(value, hiveTableSchema);
        return hiveTableSchema;
    }

    public static void put(Configuration conf, String profile, HiveTableSchema hiveTableSchema) {
        conf.set(HiveTableSchemas.profileKey(profile), Writables.writeToEncodedStr(hiveTableSchema));
    }

    public static void put(Configuration conf, String profile, HiveTableName tableName) {
        Table table;
        HiveConf hiveConf = new HiveConf(conf, HiveTableSchemas.class);
        try {
            ThriftHiveMetastore.Iface client = HiveMetastores.create(hiveConf);
            table = client.get_table(tableName.getDatabaseName(), tableName.getTableName());
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        HiveTableSchemas.put(conf, profile, HiveTableSchemaImpl.fromTable(table));
    }

    private static String profileKey(String profile) {
        return PROFILE_KEY_PREFIX + profile;
    }
}

