/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.giraph.hive.schema;

import com.facebook.giraph.hive.common.HiveTableName;
import com.facebook.giraph.hive.common.HiveUtils;
import com.facebook.giraph.hive.common.Writables;
import com.facebook.giraph.hive.schema.HiveTableSchema;
import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.io.WritableUtils;

public class HiveTableSchemaImpl
implements HiveTableSchema {
    private HiveTableName tableName;
    private final Map<String, Integer> partitionPositions;
    private final Map<String, Integer> columnPositions;
    private int numColumns;

    public HiveTableSchemaImpl() {
        this.tableName = new HiveTableName("_unknown_", "_unknown_");
        this.partitionPositions = Maps.newHashMap();
        this.columnPositions = Maps.newHashMap();
    }

    public HiveTableSchemaImpl(HiveTableName tableName, Map<String, Integer> partitionPositions, Map<String, Integer> columnPositions) {
        this.tableName = tableName;
        this.partitionPositions = partitionPositions;
        this.columnPositions = columnPositions;
        this.numColumns = HiveTableSchemaImpl.computeNumColumns(columnPositions);
    }

    public static HiveTableSchemaImpl fromTable(Table table) {
        int index = 0;
        List columnNames = Lists.transform((List)table.getSd().getCols(), HiveUtils.FIELD_SCHEMA_NAME_GETTER);
        HashMap columnToIndex = Maps.newHashMap();
        for (String columnName : columnNames) {
            columnToIndex.put(columnName, index++);
        }
        List partitionNames = Lists.transform((List)table.getPartitionKeys(), HiveUtils.FIELD_SCHEMA_NAME_GETTER);
        HashMap partitionToIndex = Maps.newHashMap();
        for (String partitionName : partitionNames) {
            partitionToIndex.put(partitionName, index++);
        }
        HiveTableName hiveTableName = new HiveTableName(table.getDbName(), table.getTableName());
        return new HiveTableSchemaImpl(hiveTableName, partitionToIndex, columnToIndex);
    }

    private static int computeNumColumns(Map<String, Integer> columnPositions) {
        return (Integer)Ordering.natural().max(columnPositions.values()) + 1;
    }

    @Override
    public HiveTableName getTableName() {
        return this.tableName;
    }

    @Override
    public int numColumns() {
        return this.numColumns;
    }

    @Override
    public int positionOf(String columnOrPartitionKeyName) {
        Integer index = this.columnPositions.get(columnOrPartitionKeyName);
        if (index == null && (index = this.partitionPositions.get(columnOrPartitionKeyName)) == null) {
            throw new IllegalArgumentException("Column or partition " + columnOrPartitionKeyName + " not found in schema " + this);
        }
        return index;
    }

    public void write(DataOutput out) throws IOException {
        Writables.writeStrIntMap(out, this.partitionPositions);
        Writables.writeStrIntMap(out, this.columnPositions);
        WritableUtils.writeString((DataOutput)out, (String)this.tableName.getDatabaseName());
        WritableUtils.writeString((DataOutput)out, (String)this.tableName.getTableName());
    }

    public void readFields(DataInput in) throws IOException {
        Writables.readStrIntMap(in, this.partitionPositions);
        Writables.readStrIntMap(in, this.columnPositions);
        this.numColumns = HiveTableSchemaImpl.computeNumColumns(this.columnPositions);
        String dbName = WritableUtils.readString((DataInput)in);
        String tblName = WritableUtils.readString((DataInput)in);
        this.tableName = new HiveTableName(dbName, tblName);
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("partitionKeys", this.partitionPositions).add("columnPositions", this.columnPositions).toString();
    }
}

