/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.giraph.hive.output;

import com.facebook.giraph.hive.common.Writables;
import com.facebook.giraph.hive.output.HiveOutputDescription;
import com.facebook.giraph.hive.output.OutputInfo;
import com.google.common.base.Objects;
import org.apache.hadoop.conf.Configuration;

class OutputConf {
    public static final String PREFIX_KEY = "hive.io.output";
    public static final String OUTPUT_TABLE_INFO_KEY = "table_info";
    public static final String OUTPUT_DESCRIPTION_KEY = "description";
    private final Configuration conf;
    private final String profileId;

    public OutputConf(Configuration conf, String profileId) {
        this.conf = conf;
        this.profileId = profileId;
    }

    public Configuration getConf() {
        return this.conf;
    }

    public String getProfileId() {
        return this.profileId;
    }

    public String getProfilePrefix() {
        return "hive.io.output." + this.profileId + ".";
    }

    public String getOutputTableInfoKey() {
        return this.getProfileId() + OUTPUT_TABLE_INFO_KEY;
    }

    public String getOutputDescriptionKey() {
        return this.getProfileId() + OUTPUT_DESCRIPTION_KEY;
    }

    public OutputInfo readOutputTableInfo() {
        OutputInfo oti = new OutputInfo();
        String value = this.conf.get(this.getOutputTableInfoKey());
        Writables.readFieldsFromEncodedStr(value, oti);
        return oti;
    }

    public void writeOutputTableInfo(OutputInfo oti) {
        this.conf.set(this.getOutputTableInfoKey(), Writables.writeToEncodedStr(oti));
    }

    public HiveOutputDescription readOutputDescription() {
        HiveOutputDescription hod = new HiveOutputDescription();
        String value = this.conf.get(this.getOutputDescriptionKey());
        Writables.readFieldsFromEncodedStr(value, hod);
        return hod;
    }

    public void writeOutputDescription(HiveOutputDescription hod) {
        this.conf.set(this.getOutputDescriptionKey(), Writables.writeToEncodedStr(hod));
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("profileId", (Object)this.profileId).toString();
    }
}

