/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.giraph.hive.output;

import com.facebook.giraph.hive.common.HiveTableName;
import com.facebook.giraph.hive.common.Writables;
import com.google.common.base.Objects;
import com.google.common.collect.Maps;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Map;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableUtils;

public class HiveOutputDescription
implements Writable {
    private String dbName = "default";
    private String tableName = "";
    private Map<String, String> partitionValues = Maps.newHashMap();

    public String getDbName() {
        return this.dbName;
    }

    public HiveOutputDescription setDbName(String dbName) {
        this.dbName = dbName;
        return this;
    }

    public boolean hasDbName() {
        return this.dbName != null && !this.dbName.isEmpty();
    }

    public String getTableName() {
        return this.tableName;
    }

    public HiveOutputDescription setTableName(String tableName) {
        this.tableName = tableName;
        return this;
    }

    public boolean hasTableName() {
        return this.tableName != null && !this.tableName.isEmpty();
    }

    public HiveTableName hiveTableName() {
        return new HiveTableName(this.dbName, this.tableName);
    }

    public Map<String, String> getPartitionValues() {
        return this.partitionValues;
    }

    public int numPartitionValues() {
        return this.partitionValues.size();
    }

    public boolean hasPartitionValues() {
        return this.partitionValues != null && !this.partitionValues.isEmpty();
    }

    public HiveOutputDescription setPartitionValues(Map<String, String> partitionValues) {
        this.partitionValues = partitionValues;
        return this;
    }

    public void write(DataOutput out) throws IOException {
        WritableUtils.writeString((DataOutput)out, (String)this.dbName);
        WritableUtils.writeString((DataOutput)out, (String)this.tableName);
        Writables.writeStrStrMap(out, this.partitionValues);
    }

    public void readFields(DataInput in) throws IOException {
        this.dbName = WritableUtils.readString((DataInput)in);
        this.tableName = WritableUtils.readString((DataInput)in);
        Writables.readStrStrMap(in, this.partitionValues);
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("dbName", (Object)this.dbName).add("tableName", (Object)this.tableName).add("partitionValues", this.partitionValues).toString();
    }
}

