/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.giraph.hive.output;

import com.facebook.giraph.hive.common.FileSystems;
import com.facebook.giraph.hive.common.HadoopUtils;
import com.facebook.giraph.hive.common.HiveUtils;
import com.facebook.giraph.hive.common.Inspectors;
import com.facebook.giraph.hive.common.ProgressReporter;
import com.facebook.giraph.hive.input.HiveApiInputFormat;
import com.facebook.giraph.hive.output.HiveApiOutputCommitter;
import com.facebook.giraph.hive.output.HiveOutputDescription;
import com.facebook.giraph.hive.output.OutputConf;
import com.facebook.giraph.hive.output.OutputInfo;
import com.facebook.giraph.hive.output.RecordWriterImpl;
import com.facebook.giraph.hive.record.HiveWritableRecord;
import com.facebook.giraph.hive.schema.HiveTableSchema;
import com.facebook.giraph.hive.schema.HiveTableSchemaImpl;
import com.facebook.giraph.hive.schema.HiveTableSchemas;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.HiveMetaStoreClient;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.serde2.Serializer;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.OutputCommitter;
import org.apache.hadoop.mapred.OutputFormat;
import org.apache.hadoop.mapred.RecordWriter;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.util.Progressable;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.log4j.Logger;
import org.apache.thrift.TException;

public class HiveApiOutputFormat
extends org.apache.hadoop.mapreduce.OutputFormat<WritableComparable, HiveWritableRecord> {
    public static final Logger LOG = Logger.getLogger(HiveApiOutputFormat.class);
    public static final String DEFAULT_PROFILE_ID = "output-profile";
    private String myProfileId = "output-profile";

    public String getMyProfileId() {
        return this.myProfileId;
    }

    public void setMyProfileId(String myProfileId) {
        this.myProfileId = myProfileId;
    }

    public HiveTableSchema getTableSchema(Configuration conf) {
        return HiveTableSchemas.get(conf, this.myProfileId);
    }

    public void init(Configuration conf, HiveOutputDescription outputDesc) throws TException {
        HiveApiOutputFormat.initProfile(conf, outputDesc, this.myProfileId);
    }

    public static void initDefaultProfile(Configuration conf, HiveOutputDescription outputDesc) throws TException {
        HiveApiOutputFormat.initProfile(conf, outputDesc, DEFAULT_PROFILE_ID);
    }

    public static void initProfile(Configuration conf, HiveOutputDescription outputDesc, String profileId) throws TException {
        String dbName = outputDesc.getDbName();
        String tableName = outputDesc.getTableName();
        HiveConf hiveConf = new HiveConf(conf, HiveApiInputFormat.class);
        HiveMetaStoreClient client = new HiveMetaStoreClient(hiveConf);
        Table table = client.getTable(dbName, tableName);
        HiveApiOutputFormat.sanityCheck(table, outputDesc);
        OutputInfo oti = new OutputInfo(table);
        String partitionPiece = oti.hasPartitionInfo() ? HiveUtils.computePartitionPath(oti.getPartitionInfo(), outputDesc.getPartitionValues()) : "_temp";
        String partitionPath = oti.getTableRoot() + "/" + partitionPiece;
        oti.setPartitionPath(partitionPath);
        HadoopUtils.setOutputDir(conf, partitionPath);
        if (oti.hasPartitionInfo()) {
            oti.setFinalOutputPath(oti.getPartitionPath());
        } else {
            oti.setFinalOutputPath(oti.getTableRoot());
        }
        HiveTableSchemaImpl tableSchema = HiveTableSchemaImpl.fromTable(table);
        HiveTableSchemas.put(conf, profileId, tableSchema);
        OutputConf outputConf = new OutputConf(conf, profileId);
        outputConf.writeOutputDescription(outputDesc);
        outputConf.writeOutputTableInfo(oti);
        LOG.info((Object)("initProfile '" + profileId + "' using " + outputDesc));
    }

    private static void sanityCheck(Table table, HiveOutputDescription outputDesc) {
        StorageDescriptor sd = table.getSd();
        Preconditions.checkArgument((!sd.isCompressed() ? 1 : 0) != 0);
        Preconditions.checkArgument((boolean)HiveApiOutputFormat.nullOrEmpty(sd.getBucketCols()));
        Preconditions.checkArgument((boolean)HiveApiOutputFormat.nullOrEmpty(sd.getSortCols()));
        Preconditions.checkArgument((table.getPartitionKeysSize() == outputDesc.numPartitionValues() ? 1 : 0) != 0);
    }

    private static <X> boolean nullOrEmpty(Collection<X> c) {
        return c == null || c.isEmpty();
    }

    private List<String> listOfPartitionValues(Map<String, String> partitionValues, List<FieldSchema> fieldSchemas) {
        ArrayList values = Lists.newArrayList();
        for (FieldSchema fieldSchema : fieldSchemas) {
            String value = partitionValues.get(fieldSchema.getName().toLowerCase());
            values.add(value);
        }
        return values;
    }

    public void checkOutputSpecs(JobContext jobContext) throws IOException, InterruptedException {
        Configuration conf = jobContext.getConfiguration();
        OutputConf outputConf = new OutputConf(conf, this.myProfileId);
        HiveOutputDescription description = outputConf.readOutputDescription();
        OutputInfo oti = outputConf.readOutputTableInfo();
        if (oti.hasPartitionInfo()) {
            if (!description.hasPartitionValues()) {
                throw new IOException("table is partitioned but user input isn't");
            }
            this.checkPartitionDoesntExist(conf, description, oti);
        } else {
            if (description.hasPartitionValues()) {
                throw new IOException("table is not partitioned but user input is");
            }
            this.checkTableIsEmpty(conf, description, oti);
        }
    }

    private void checkTableIsEmpty(Configuration conf, HiveOutputDescription description, OutputInfo oti) throws IOException {
        Path tablePath = new Path(oti.getTableRoot());
        FileSystem fs = tablePath.getFileSystem(conf);
        if (fs.exists(tablePath) && FileSystems.dirHasNonHiddenFiles(fs, tablePath)) {
            throw new IOException("Table " + description.getTableName() + " has existing data");
        }
    }

    private void checkPartitionDoesntExist(Configuration conf, HiveOutputDescription description, OutputInfo oti) throws IOException {
        Map<String, String> partitionSpec;
        List<String> partitionValues;
        HiveMetaStoreClient client;
        HiveConf hiveConf = new HiveConf(conf, HiveApiInputFormat.class);
        try {
            client = new HiveMetaStoreClient(hiveConf);
        }
        catch (MetaException e) {
            throw new IOException(e);
        }
        String db = description.getDbName();
        String table = description.getTableName();
        if (oti.hasPartitionInfo() && this.partitionExists(client, db, table, partitionValues = this.listOfPartitionValues(partitionSpec = description.getPartitionValues(), oti.getPartitionInfo()))) {
            throw new IOException("Table " + db + ":" + table + " partition " + partitionSpec + " already exists");
        }
    }

    private boolean partitionExists(HiveMetaStoreClient client, String db, String table, List<String> partitionValues) {
        List partitionNames;
        try {
            partitionNames = client.listPartitionNames(db, table, partitionValues, (short)1);
        }
        catch (Exception e) {
            return false;
        }
        return !partitionNames.isEmpty();
    }

    public RecordWriterImpl getRecordWriter(TaskAttemptContext taskAttemptContext) throws IOException, InterruptedException {
        HadoopUtils.setWorkOutputDir(taskAttemptContext);
        Configuration conf = taskAttemptContext.getConfiguration();
        OutputConf outputConf = new OutputConf(conf, this.myProfileId);
        OutputInfo oti = outputConf.readOutputTableInfo();
        HiveUtils.setRCileNumColumns(conf, oti.getColumnInfo().size());
        HadoopUtils.setOutputKeyWritableClass(conf, NullWritable.class);
        Serializer serializer = oti.createSerializer(conf);
        HadoopUtils.setOutputValueWritableClass(conf, serializer.getSerializedClass());
        OutputFormat baseOutputFormat = (OutputFormat)ReflectionUtils.newInstance(oti.getOutputFormatClass(), (Configuration)conf);
        RecordWriter<WritableComparable, Writable> baseWriter = this.getBaseRecordWriter(taskAttemptContext, baseOutputFormat);
        StructObjectInspector soi = Inspectors.createFor(oti.getColumnInfo());
        return new RecordWriterImpl(baseWriter, serializer, (ObjectInspector)soi);
    }

    private RecordWriter<WritableComparable, Writable> getBaseRecordWriter(TaskAttemptContext taskAttemptContext, OutputFormat baseOutputFormat) throws IOException {
        JobConf jobConf = new JobConf(taskAttemptContext.getConfiguration());
        String name = FileOutputFormat.getUniqueName((JobConf)jobConf, (String)"part");
        ProgressReporter reporter = new ProgressReporter((Progressable)taskAttemptContext);
        return baseOutputFormat.getRecordWriter(null, jobConf, name, (Progressable)reporter);
    }

    public org.apache.hadoop.mapreduce.OutputCommitter getOutputCommitter(TaskAttemptContext taskAttemptContext) throws IOException, InterruptedException {
        HadoopUtils.setWorkOutputDir(taskAttemptContext);
        Configuration conf = taskAttemptContext.getConfiguration();
        JobConf jobConf = new JobConf(conf);
        OutputCommitter baseCommitter = jobConf.getOutputCommitter();
        return new HiveApiOutputCommitter((org.apache.hadoop.mapreduce.OutputCommitter)baseCommitter, this.myProfileId);
    }
}

