/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.giraph.hive.output;

import com.facebook.giraph.hive.common.FileSystems;
import com.facebook.giraph.hive.common.HadoopUtils;
import com.facebook.giraph.hive.common.HiveUtils;
import com.facebook.giraph.hive.output.HiveOutputDescription;
import com.facebook.giraph.hive.output.OutputConf;
import com.facebook.giraph.hive.output.OutputInfo;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.HiveMetaStoreClient;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.JobStatus;
import org.apache.hadoop.mapreduce.OutputCommitter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;

class HiveApiOutputCommitter
extends OutputCommitter {
    private final OutputCommitter baseCommitter;
    private final String profileId;

    public HiveApiOutputCommitter(OutputCommitter baseCommitter, String profileId) {
        this.baseCommitter = baseCommitter;
        this.profileId = profileId;
    }

    public void setupJob(JobContext jobContext) throws IOException {
        this.baseCommitter.setupJob(jobContext);
    }

    public void commitJob(JobContext jobContext) throws IOException {
        this.baseCommitter.commitJob(jobContext);
        Configuration conf = jobContext.getConfiguration();
        OutputConf outputConf = new OutputConf(conf, this.profileId);
        HiveOutputDescription outputDesc = outputConf.readOutputDescription();
        OutputInfo outputInfo = outputConf.readOutputTableInfo();
        if (outputInfo.hasPartitionInfo()) {
            this.registerPartitions(conf, outputDesc, outputInfo);
        } else {
            this.noPartitionsCopyData(conf, outputInfo);
        }
        HiveApiOutputCommitter.writeSuccessFile(conf);
    }

    private static void writeSuccessFile(Configuration conf) throws IOException {
        Path successPath;
        if (!HadoopUtils.needSuccessMarker(conf)) {
            return;
        }
        Path outputPath = new Path(HadoopUtils.getOutputDir(conf));
        FileSystem fs = FileSystem.get((Configuration)conf);
        if (fs.exists(outputPath) && !fs.exists(successPath = new Path(outputPath, "_SUCCESS"))) {
            fs.create(successPath).close();
        }
    }

    private void registerPartitions(Configuration conf, HiveOutputDescription outputDesc, OutputInfo outputInfo) throws IOException {
        Table hiveTable;
        HiveMetaStoreClient client;
        HiveConf hiveConf = new HiveConf(conf, HiveApiOutputCommitter.class);
        String dbName = outputDesc.getDbName();
        String tableName = outputDesc.getTableName();
        try {
            client = new HiveMetaStoreClient(hiveConf);
            hiveTable = client.getTable(dbName, tableName);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        Partition partition = new Partition();
        partition.setDbName(dbName);
        partition.setTableName(tableName);
        partition.setParameters(outputInfo.getTableParams());
        List<String> partitionValues = HiveUtils.orderedPartitionValues(hiveTable.getPartitionKeys(), outputDesc.getPartitionValues());
        partition.setValues(partitionValues);
        StorageDescriptor sd = new StorageDescriptor(hiveTable.getSd());
        sd.setParameters(outputInfo.getSerializerParams());
        sd.setLocation(outputInfo.getFinalOutputPath());
        sd.setCols(outputInfo.getColumnInfo());
        partition.setSd(sd);
        try {
            client.add_partition(partition);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    private void noPartitionsCopyData(Configuration conf, OutputInfo oti) throws IOException {
        Preconditions.checkArgument((!oti.hasPartitionInfo() ? 1 : 0) != 0);
        FileSystem fs = FileSystem.get((Configuration)conf);
        Path tablePath = new Path(oti.getTableRoot());
        Path writePath = new Path(oti.getPartitionPath());
        FileSystems.move(fs, writePath, writePath, tablePath);
        fs.delete(writePath, true);
    }

    @Deprecated
    public void cleanupJob(JobContext jobContext) throws IOException {
        this.baseCommitter.cleanupJob(jobContext);
    }

    public void abortJob(JobContext jobContext, JobStatus.State state) throws IOException {
        this.baseCommitter.abortJob(jobContext, state);
        HadoopUtils.deleteOutputDir(jobContext.getConfiguration());
    }

    public void setupTask(TaskAttemptContext taskContext) throws IOException {
        this.baseCommitter.setupTask(taskContext);
    }

    public boolean needsTaskCommit(TaskAttemptContext taskContext) throws IOException {
        return this.baseCommitter.needsTaskCommit(taskContext);
    }

    public void commitTask(TaskAttemptContext taskContext) throws IOException {
        HadoopUtils.setWorkOutputDir(taskContext);
        this.baseCommitter.commitTask(taskContext);
    }

    public void abortTask(TaskAttemptContext taskContext) throws IOException {
        this.baseCommitter.abortTask(taskContext);
    }
}

