/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.giraph.hive.input.parser.hive;

import com.facebook.giraph.hive.record.HiveRecord;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.hive.serde2.Deserializer;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.io.Writable;
import org.apache.log4j.Logger;

public class DefaultRecord
implements HiveRecord {
    public static final Logger LOG = Logger.getLogger(DefaultRecord.class);
    private final String[] partitionValues;
    private final Object[] rowData;

    public DefaultRecord(int numColumns, String[] partitionValues) {
        this.partitionValues = partitionValues;
        this.rowData = new Object[numColumns];
    }

    @Override
    public Object get(int index) {
        if (index < this.rowData.length) {
            return this.rowData[index];
        }
        return this.partitionValues[index - this.rowData.length];
    }

    @Override
    public boolean getBoolean(int index) {
        Boolean v = (Boolean)this.get(index);
        return v == null ? false : v;
    }

    @Override
    public long getLong(int index) {
        Long v = (Long)this.get(index);
        return v == null ? Long.MIN_VALUE : v;
    }

    @Override
    public double getDouble(int index) {
        Double v = (Double)this.get(index);
        return v == null ? Double.NaN : v;
    }

    @Override
    public String getString(int index) {
        return (String)this.get(index);
    }

    @Override
    public boolean isNull(int index) {
        return this.get(index) == null;
    }

    @Override
    public List<Object> getAllColumns() {
        return Arrays.asList(this.rowData);
    }

    @Override
    public void set(int index, Object value) {
        this.rowData[index] = value;
    }

    public int getNumColumns() {
        return this.rowData.length;
    }

    public void parse(Writable value, Deserializer deserializer) throws IOException {
        ObjectInspector dataInspector;
        Object data;
        try {
            data = deserializer.deserialize(value);
            dataInspector = deserializer.getObjectInspector();
        }
        catch (SerDeException e) {
            throw new IOException(e);
        }
        Preconditions.checkArgument((dataInspector.getCategory() == ObjectInspector.Category.STRUCT ? 1 : 0) != 0);
        StructObjectInspector structInspector = (StructObjectInspector)dataInspector;
        Object parsedData = ObjectInspectorUtils.copyToStandardJavaObject((Object)data, (ObjectInspector)structInspector);
        List parsedList = (List)parsedData;
        for (int i = 0; i < parsedList.size(); ++i) {
            this.set(i, parsedList.get(i));
        }
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("numColumns", this.getNumColumns()).add("rowData", (Object)this.rowDataToString()).add("partitionData", (Object)this.partitionValues).toString();
    }

    private String rowDataToString() {
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        for (int i = 0; i < this.rowData.length; ++i) {
            if (i > 0) {
                sb.append(',');
            }
            if (this.rowData[i] == null) {
                sb.append("(null)");
                continue;
            }
            sb.append(this.rowData[i].getClass().getSimpleName());
            sb.append(":");
            sb.append(this.rowData[i].toString());
        }
        sb.append(']');
        return sb.toString();
    }
}

