/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.giraph.hive.input.parser.hive;

import com.facebook.giraph.hive.input.parser.RecordParser;
import com.facebook.giraph.hive.input.parser.hive.DefaultRecord;
import com.facebook.giraph.hive.record.HiveReadableRecord;
import java.io.IOException;
import java.util.List;
import org.apache.hadoop.hive.serde2.Deserializer;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.io.Writable;

public class DefaultParser
implements RecordParser {
    private final Deserializer deserializer;
    private final ObjectInspector rowInspector;
    private final String[] partitionValues;
    private final int numColumns;

    public DefaultParser(Deserializer deserializer, String[] partitionValues, int numColumns) {
        this.deserializer = deserializer;
        try {
            this.rowInspector = (StructObjectInspector)deserializer.getObjectInspector();
        }
        catch (SerDeException e) {
            throw new IllegalArgumentException("Could not get object inspector", e);
        }
        this.partitionValues = partitionValues;
        this.numColumns = numColumns;
    }

    @Override
    public HiveReadableRecord createRecord() {
        return new DefaultRecord(this.numColumns, this.partitionValues);
    }

    public HiveReadableRecord parse(Writable value, HiveReadableRecord record) throws IOException {
        Object data;
        DefaultRecord defaultRecord = (DefaultRecord)record;
        try {
            data = this.deserializer.deserialize(value);
        }
        catch (SerDeException e) {
            throw new IOException(e);
        }
        Object parsedData = ObjectInspectorUtils.copyToStandardJavaObject((Object)data, (ObjectInspector)this.rowInspector);
        List parsedList = (List)parsedData;
        for (int i = 0; i < parsedList.size(); ++i) {
            defaultRecord.set(i, parsedList.get(i));
        }
        return defaultRecord;
    }
}

