/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.giraph.hive.input.parser.array;

import com.facebook.giraph.hive.common.HiveType;
import com.facebook.giraph.hive.common.NativeType;
import com.facebook.giraph.hive.record.HiveReadableRecord;
import com.google.common.base.Objects;
import java.util.Arrays;

class ArrayRecord
implements HiveReadableRecord {
    private final int numColumns;
    private final HiveType[] hiveTypes;
    private final boolean[] booleans;
    private final long[] longs;
    private final double[] doubles;
    private final String[] strings;
    private final Object[] objects;
    private final boolean[] nulls;

    public ArrayRecord(int numColumns, String[] partitionValues, HiveType[] hiveTypes) {
        this.numColumns = numColumns;
        this.hiveTypes = hiveTypes;
        int size = numColumns + partitionValues.length;
        this.booleans = new boolean[size];
        this.longs = new long[size];
        this.doubles = new double[size];
        this.strings = new String[size];
        this.objects = new Object[size];
        this.nulls = new boolean[size];
        for (int partIndex = 0; partIndex < partitionValues.length; ++partIndex) {
            this.strings[partIndex + numColumns] = partitionValues[partIndex];
        }
    }

    public int getNumColumns() {
        return this.numColumns;
    }

    public int getNumPartitionValues() {
        return this.booleans.length - this.numColumns;
    }

    public int getSize() {
        return this.booleans.length;
    }

    public void reset() {
        Arrays.fill(this.nulls, false);
    }

    public HiveType getHiveType(int index) {
        return this.hiveTypes[index];
    }

    public NativeType getNativeType(int index) {
        return this.hiveTypes[index].getNativeType();
    }

    public void setBoolean(int index, boolean value) {
        this.booleans[index] = value;
    }

    public void setLong(int index, long value) {
        this.longs[index] = value;
    }

    public void setDouble(int index, double value) {
        this.doubles[index] = value;
    }

    public void setString(int index, String value) {
        this.strings[index] = value;
    }

    public void setObject(int index, Object value) {
        this.objects[index] = value;
    }

    public void setNull(int index, boolean value) {
        this.nulls[index] = value;
    }

    @Override
    public Object get(int index) {
        if (this.nulls[index]) {
            return null;
        }
        if (this.hiveTypes[index].isCollection()) {
            return this.objects[index];
        }
        return this.getPrimitive(index);
    }

    private Object getPrimitive(int index) {
        switch (this.hiveTypes[index].getNativeType()) {
            case BOOLEAN: {
                return this.booleans[index];
            }
            case LONG: {
                return this.longs[index];
            }
            case DOUBLE: {
                return this.doubles[index];
            }
            case STRING: {
                return this.strings[index];
            }
        }
        return null;
    }

    @Override
    public boolean getBoolean(int index) {
        return this.booleans[index];
    }

    @Override
    public long getLong(int index) {
        return this.longs[index];
    }

    @Override
    public double getDouble(int index) {
        return this.doubles[index];
    }

    @Override
    public String getString(int index) {
        return this.strings[index];
    }

    @Override
    public boolean isNull(int index) {
        return this.nulls[index];
    }

    private void verifyType(int index, NativeType expectedType) {
        if (this.hiveTypes[index].getNativeType() != expectedType) {
            throw new IllegalStateException(String.format("Got an unexpected type %s from row %s for column %d, should be %s", new Object[]{this.hiveTypes[index], this, index, expectedType}));
        }
    }

    public String toString() {
        Objects.ToStringHelper tsh = Objects.toStringHelper((Object)this);
        for (int i = 0; i < this.booleans.length; ++i) {
            tsh.add("row[" + i + "]", this.get(i));
        }
        return tsh.toString();
    }
}

