/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.giraph.hive.input.parser.array;

import com.facebook.giraph.hive.input.parser.RecordParser;
import com.facebook.giraph.hive.input.parser.array.ArrayParserData;
import com.facebook.giraph.hive.input.parser.array.ArrayRecord;
import com.facebook.giraph.hive.record.HiveReadableRecord;
import java.io.IOException;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.io.Writable;

public class ArrayParser
implements RecordParser {
    private final ArrayParserData parserData;
    private final ArrayRecord record;

    public ArrayParser(String[] partitionValues, int numColumns, ArrayParserData parserData) {
        this.parserData = parserData;
        this.record = new ArrayRecord(numColumns, partitionValues, parserData.hiveTypes);
    }

    @Override
    public HiveReadableRecord createRecord() {
        return this.record;
    }

    public HiveReadableRecord parse(Writable value, HiveReadableRecord record) throws IOException {
        Object rowData;
        ArrayRecord arrayRecord = (ArrayRecord)record;
        arrayRecord.reset();
        try {
            rowData = this.parserData.deserializer.deserialize(value);
        }
        catch (SerDeException e) {
            throw new IOException(e);
        }
        for (int i = 0; i < this.parserData.columnIndexes.length; ++i) {
            int columnIndex = this.parserData.columnIndexes[i];
            StructField structField = this.parserData.structFields[columnIndex];
            Object fieldData = this.parserData.inspector.getStructFieldData(rowData, structField);
            if (fieldData == null) {
                arrayRecord.setNull(columnIndex, true);
                continue;
            }
            if (arrayRecord.getHiveType(columnIndex).isCollection()) {
                ObjectInspector fieldInspector = structField.getFieldObjectInspector();
                Object parsed = ObjectInspectorUtils.copyToStandardJavaObject((Object)fieldData, (ObjectInspector)fieldInspector);
                arrayRecord.setObject(columnIndex, parsed);
                continue;
            }
            this.parsePrimitive(arrayRecord, columnIndex, fieldData);
        }
        return arrayRecord;
    }

    private void parsePrimitive(ArrayRecord arrayRecord, int columnIndex, Object fieldData) {
        PrimitiveObjectInspector fieldInspector = this.parserData.primitiveInspectors[columnIndex];
        Object primitiveData = fieldInspector.getPrimitiveJavaObject(fieldData);
        switch (arrayRecord.getNativeType(columnIndex)) {
            case BOOLEAN: {
                arrayRecord.setBoolean(columnIndex, (Boolean)primitiveData);
                break;
            }
            case LONG: {
                arrayRecord.setLong(columnIndex, ((Number)primitiveData).longValue());
                break;
            }
            case DOUBLE: {
                arrayRecord.setDouble(columnIndex, ((Number)primitiveData).doubleValue());
                break;
            }
            case STRING: {
                arrayRecord.setString(columnIndex, (String)primitiveData);
            }
        }
    }
}

