/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.giraph.hive.input.parser;

import com.facebook.giraph.hive.common.HiveTableName;
import com.facebook.giraph.hive.common.HiveType;
import com.facebook.giraph.hive.input.parser.RecordParser;
import com.facebook.giraph.hive.input.parser.array.ArrayParser;
import com.facebook.giraph.hive.input.parser.array.ArrayParserData;
import com.facebook.giraph.hive.input.parser.array.BytesParser;
import org.apache.hadoop.hive.serde2.Deserializer;
import org.apache.hadoop.hive.serde2.columnar.BytesRefArrayWritable;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.io.Writable;
import org.apache.log4j.Logger;

public class Parsers {
    private static final Logger LOG = Logger.getLogger(Parsers.class);

    public static RecordParser<Writable> bestParser(Deserializer deserializer, int numColumns, int[] columnIndexes, HiveTableName tableName, String[] partitionValues, Writable exampleValue) {
        ArrayParserData data = new ArrayParserData(deserializer, columnIndexes, numColumns, partitionValues);
        for (int i = 0; i < numColumns; ++i) {
            data.structFields[i] = (StructField)data.inspector.getAllStructFieldRefs().get(i);
            ObjectInspector fieldInspector = data.structFields[i].getFieldObjectInspector();
            data.hiveTypes[i] = HiveType.fromHiveObjectInspector(fieldInspector);
            if (!data.hiveTypes[i].isPrimitive()) continue;
            data.primitiveInspectors[i] = (PrimitiveObjectInspector)fieldInspector;
        }
        boolean hasCollections = false;
        for (int i = 0; i < columnIndexes.length; ++i) {
            int columnId = columnIndexes[i];
            if (!data.hiveTypes[columnId].isCollection()) continue;
            hasCollections = true;
            break;
        }
        RecordParser parser = null;
        parser = !hasCollections && exampleValue instanceof BytesRefArrayWritable ? new BytesParser(partitionValues, numColumns, data) : new ArrayParser(partitionValues, numColumns, data);
        LOG.info((Object)("Using " + parser.getClass().getSimpleName() + " to parse hive records from table " + tableName.dotString()));
        return parser;
    }
}

