/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.giraph.hive.input.benchmark;

import com.facebook.giraph.hive.input.HiveApiInputObserver;
import com.facebook.giraph.hive.input.benchmark.CounterRatioGauge;
import com.facebook.giraph.hive.record.HiveReadableRecord;
import com.yammer.metrics.Metrics;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.Timer;
import com.yammer.metrics.core.TimerContext;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;

class MetricsObserver
extends HiveApiInputObserver.Empty {
    private final int printPeriod;
    private final Timer readTimer;
    private TimerContext readTimerContext;
    private final CounterRatioGauge readSuccessRatio;
    private final Timer parseTimer;
    private TimerContext parseTimerContext;

    public MetricsObserver(String name, int printPeriod) {
        TimeUnit durationUnit = TimeUnit.MICROSECONDS;
        TimeUnit rateUnit = TimeUnit.MILLISECONDS;
        this.printPeriod = printPeriod;
        this.readTimer = Metrics.newTimer((MetricName)new MetricName(name, "", "reads"), (TimeUnit)durationUnit, (TimeUnit)rateUnit);
        this.readSuccessRatio = new CounterRatioGauge(Metrics.newCounter((MetricName)new MetricName(name, "", "successes")), Metrics.newCounter((MetricName)new MetricName(name, "", "-reads")));
        this.parseTimer = Metrics.newTimer((MetricName)new MetricName(name, "", "parses"), (TimeUnit)durationUnit, (TimeUnit)rateUnit);
    }

    public Timer getParseTimer() {
        return this.parseTimer;
    }

    public CounterRatioGauge getReadSuccessRatio() {
        return this.readSuccessRatio;
    }

    public Timer getReadTimer() {
        return this.readTimer;
    }

    @Override
    public void beginReadRow() {
        this.readTimerContext = this.readTimer.time();
    }

    @Override
    public void endReadRow(WritableComparable key, Writable value) {
        this.readSuccessRatio.getNumeratorCounter().inc();
        this.readSuccessRatio.getDenominatorCounter().inc();
        this.readTimerContext.stop();
        MetricsObserver.print(this.readTimer.count(), this.printPeriod, "read");
    }

    @Override
    public void hiveReadRowFailed() {
        this.readSuccessRatio.getDenominatorCounter().inc();
        this.readTimerContext.stop();
    }

    @Override
    public void beginParse() {
        this.parseTimerContext = this.parseTimer.time();
    }

    @Override
    public void endParse(HiveReadableRecord record) {
        this.parseTimerContext.stop();
    }

    private static void print(long num, int printEvery, String prefix) {
        if (num % (long)printEvery == 0L) {
            System.err.println(prefix + " " + num + " records");
        }
    }
}

