/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.giraph.hive.input.benchmark;

import com.facebook.giraph.hive.common.HiveMetastores;
import com.facebook.giraph.hive.input.HiveApiInputFormat;
import com.facebook.giraph.hive.input.HiveInputDescription;
import com.facebook.giraph.hive.input.RecordReaderImpl;
import com.facebook.giraph.hive.input.benchmark.BenchmarkArgs;
import com.facebook.giraph.hive.input.benchmark.HadoopNative;
import com.facebook.giraph.hive.input.benchmark.MetricsObserver;
import com.facebook.giraph.hive.record.HiveReadableRecord;
import com.google.common.base.Optional;
import com.sampullara.cli.Args;
import com.yammer.metrics.Metrics;
import com.yammer.metrics.core.Timer;
import com.yammer.metrics.core.TimerContext;
import com.yammer.metrics.reporting.ConsoleReporter;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.ThriftHiveMetastore;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.log4j.Logger;
import org.apache.thrift.transport.TTransportException;

public class InputBenchmark {
    private static final Logger LOG = Logger.getLogger(InputBenchmark.class);
    private static int rowsPrinted = 0;

    protected InputBenchmark() {
    }

    public static void main(String[] args) throws Exception {
        HadoopNative.requireHadoopNative();
        Optional<BenchmarkArgs> parsedArgs = InputBenchmark.handleCommandLine(args);
        if (!parsedArgs.isPresent()) {
            return;
        }
        Timer allTime = Metrics.newTimer(InputBenchmark.class, (String)"all-time", (TimeUnit)TimeUnit.MILLISECONDS, (TimeUnit)TimeUnit.MILLISECONDS);
        TimerContext allTimerContext = allTime.time();
        InputBenchmark.run((BenchmarkArgs)parsedArgs.get());
        allTimerContext.stop();
        new ConsoleReporter(System.err).run();
    }

    private static Optional<BenchmarkArgs> handleCommandLine(String[] args) {
        BenchmarkArgs parsedArgs = new BenchmarkArgs();
        try {
            Args.parse((Object)parsedArgs, (String[])args);
        }
        catch (IllegalArgumentException e) {
            System.err.println("ERROR: " + e);
            Args.usage((Object)parsedArgs);
            return Optional.absent();
        }
        if (parsedArgs.isHelp()) {
            Args.usage((Object)parsedArgs);
            return Optional.absent();
        }
        return Optional.of((Object)parsedArgs);
    }

    private static void run(BenchmarkArgs parsedArgs) throws TTransportException, IOException, InterruptedException {
        HiveInputDescription input = new HiveInputDescription();
        input.setDbName(parsedArgs.getDatabase());
        input.setTableName(parsedArgs.getTable());
        input.setPartitionFilter(parsedArgs.getPartitionFilter());
        HiveConf hiveConf = new HiveConf(InputBenchmark.class);
        ThriftHiveMetastore.Iface client = HiveMetastores.create(parsedArgs.getHiveHost(), parsedArgs.getHivePort());
        System.err.println("Initialize profile with input data");
        HiveApiInputFormat.setProfileInputDesc((Configuration)hiveConf, input, "input-profile");
        HiveApiInputFormat defaultInputFormat = new HiveApiInputFormat();
        if (parsedArgs.isTrackMetrics()) {
            defaultInputFormat.setObserver(new MetricsObserver("default", parsedArgs.getRecordPrintPeriod()));
        }
        List<InputSplit> splits = defaultInputFormat.getSplits(hiveConf, client);
        System.err.println("getSplits returned " + splits.size() + " splits");
        long numRows = 0L;
        for (int i = 0; i < splits.size(); ++i) {
            InputSplit split = splits.get(i);
            TaskAttemptID taskID = new TaskAttemptID();
            TaskAttemptContext taskContext = new TaskAttemptContext((Configuration)hiveConf, taskID);
            if (i % parsedArgs.getSplitPrintPeriod() == 0) {
                System.err.println("Handling split " + i + " of " + splits.size());
            }
            RecordReaderImpl reader = defaultInputFormat.createRecordReader(split, taskContext);
            reader.initialize(split, taskContext);
            numRows += InputBenchmark.readFully(reader);
        }
        System.err.println("Parsed " + numRows + " rows");
    }

    private static long readFully(RecordReader<WritableComparable, HiveReadableRecord> reader) throws IOException, InterruptedException {
        long num = 0L;
        while (reader.nextKeyValue()) {
            HiveReadableRecord record = (HiveReadableRecord)reader.getCurrentValue();
            InputBenchmark.parseLongLongDouble(record);
            ++num;
        }
        return num;
    }

    private static void parseLongLongDouble(HiveReadableRecord record) {
        record.getLong(0);
        record.getLong(1);
        record.getDouble(2);
    }
}

