/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.giraph.hive.input.benchmark;

import com.google.common.collect.Lists;
import com.google.common.io.Files;
import com.google.common.io.InputSupplier;
import com.google.common.io.Resources;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.URL;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.ql.io.CodecPool;
import org.apache.hadoop.io.compress.CompressionCodecFactory;
import org.apache.hadoop.util.NativeCodeLoader;

class HadoopNative {
    private static boolean loaded = false;
    private static Throwable error = null;

    HadoopNative() {
    }

    public static synchronized void requireHadoopNative() {
        if (loaded) {
            return;
        }
        if (error != null) {
            throw new RuntimeException("failed to load Hadoop native library", error);
        }
        try {
            HadoopNative.loadLibrary("hadoop");
            Field field = NativeCodeLoader.class.getDeclaredField("nativeCodeLoaded");
            field.setAccessible(true);
            field.set(null, true);
            field = CodecPool.class.getDeclaredField("COMPRESSOR_POOL");
            HadoopNative.setFinalStatic(field, new HackListMap());
            field = CodecPool.class.getDeclaredField("DECOMPRESSOR_POOL");
            HadoopNative.setFinalStatic(field, new HackListMap());
            CompressionCodecFactory.getCodecClasses((Configuration)new Configuration());
            loaded = true;
        }
        catch (Throwable t) {
            error = t;
            throw new RuntimeException("failed to load Hadoop native library", error);
        }
    }

    private static void setFinalStatic(Field field, Object newValue) throws Exception {
        field.setAccessible(true);
        Field modifiersField = Field.class.getDeclaredField("modifiers");
        modifiersField.setAccessible(true);
        modifiersField.setInt(field, field.getModifiers() & 0xFFFFFFEF);
        field.set(null, newValue);
    }

    private static void loadLibrary(String name) throws IOException {
        URL url = Resources.getResource(HadoopNative.class, (String)HadoopNative.getLibraryPath(name));
        File file = File.createTempFile(name, null);
        file.deleteOnExit();
        Files.copy((InputSupplier)Resources.newInputStreamSupplier((URL)url), (File)file);
        System.load(file.getAbsolutePath());
    }

    private static String getLibraryPath(String name) {
        return "/nativelib/" + HadoopNative.getPlatform() + "/" + System.mapLibraryName(name);
    }

    private static String getPlatform() {
        String name = System.getProperty("os.name");
        String arch = System.getProperty("os.arch");
        return (name + "-" + arch).replace(' ', '_');
    }

    private static class HackListMap<K, V>
    extends AbstractMap<K, List<? extends V>> {
        private HackListMap() {
        }

        @Override
        public Set<Map.Entry<K, List<? extends V>>> entrySet() {
            return Collections.emptySet();
        }

        @Override
        public List<? extends V> put(K key, List<? extends V> value) {
            return null;
        }

        @Override
        public List<? extends V> get(Object key) {
            return Lists.newArrayList();
        }
    }
}

