/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.giraph.hive.input;

import com.facebook.giraph.hive.common.SerDes;
import com.facebook.giraph.hive.common.Writables;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.SerDeInfo;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.serde2.Deserializer;
import org.apache.hadoop.io.Writable;
import org.apache.log4j.Logger;

class InputSplitData
implements Writable {
    public static final Logger LOG = Logger.getLogger(InputSplitData.class);
    private Class<? extends Deserializer> deserializerClass;
    private final Map<String, String> deserializerParams;
    private final List<FieldSchema> columnInfo;
    private final List<String> partitionValues;

    public InputSplitData() {
        this.deserializerParams = Maps.newHashMap();
        this.columnInfo = Lists.newArrayList();
        this.partitionValues = Lists.newArrayList();
    }

    public InputSplitData(StorageDescriptor storageDescriptor, List<String> partitionValues) {
        this.columnInfo = storageDescriptor.getCols();
        SerDeInfo serDeInfo = storageDescriptor.getSerdeInfo();
        this.deserializerClass = SerDes.getSerDeClass(serDeInfo);
        this.deserializerParams = serDeInfo.getParameters();
        this.partitionValues = partitionValues;
    }

    public Deserializer createDeserializer() {
        Preconditions.checkNotNull(this.deserializerClass);
        Deserializer deserializer = null;
        try {
            Constructor<? extends Deserializer> constructor = this.deserializerClass.getDeclaredConstructor(new Class[0]);
            constructor.setAccessible(true);
            deserializer = constructor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            LOG.fatal((Object)("Could not instantiate Deserializer " + this.deserializerClass), (Throwable)e);
        }
        return deserializer;
    }

    public boolean hasDeserializerClass() {
        return this.deserializerClass != null;
    }

    public Class<? extends Deserializer> getDeserializerClass() {
        return this.deserializerClass;
    }

    public Map<String, String> getDeserializerParams() {
        return this.deserializerParams;
    }

    public List<FieldSchema> getColumnInfo() {
        return this.columnInfo;
    }

    public List<String> getPartitionValues() {
        return this.partitionValues;
    }

    public void write(DataOutput out) throws IOException {
        Writables.writeFieldSchemas(out, this.columnInfo);
        Writables.writeClassName(out, (Class)Preconditions.checkNotNull(this.deserializerClass));
        Writables.writeStrStrMap(out, this.deserializerParams);
        Writables.writeStringList(out, this.partitionValues);
    }

    public void readFields(DataInput in) throws IOException {
        Writables.readFieldSchemas(in, this.columnInfo);
        this.deserializerClass = Writables.readClass(in);
        Writables.readStrStrMap(in, this.deserializerParams);
        Writables.readStringList(in, this.partitionValues);
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("columnInfo", this.columnInfo).add("deserializerClass", this.deserializerClass).add("deserializerParams", this.deserializerParams).add("partitionValues", this.partitionValues).toString();
    }
}

