/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.giraph.hive.input;

import com.facebook.giraph.hive.common.HiveTableName;
import com.facebook.giraph.hive.common.Writables;
import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.List;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableUtils;

public class HiveInputDescription
implements Writable {
    private String dbName = "default";
    private String tableName = "";
    private List<String> columns = Lists.newArrayList();
    private String partitionFilter = "";
    private int numSplits;

    public List<String> getColumns() {
        return this.columns;
    }

    public HiveInputDescription addColumn(String column) {
        this.columns.add(column);
        return this;
    }

    public HiveInputDescription setColumns(List<String> columns) {
        this.columns = columns;
        return this;
    }

    public boolean hasColumns() {
        return this.columns != null && !this.columns.isEmpty();
    }

    public String getDbName() {
        return this.dbName;
    }

    public HiveInputDescription setDbName(String dbName) {
        this.dbName = dbName;
        return this;
    }

    public String getTableName() {
        return this.tableName;
    }

    public HiveInputDescription setTableName(String tableName) {
        this.tableName = tableName;
        return this;
    }

    public boolean hasTableName() {
        return this.tableName != null && !this.tableName.isEmpty();
    }

    public HiveTableName hiveTableName() {
        return new HiveTableName(this.dbName, this.tableName);
    }

    public String getPartitionFilter() {
        return this.partitionFilter;
    }

    public HiveInputDescription setPartitionFilter(String partitionFilter) {
        this.partitionFilter = partitionFilter;
        return this;
    }

    public boolean hasPartitionFilter() {
        return this.partitionFilter != null && !this.partitionFilter.isEmpty();
    }

    public int getNumSplits() {
        return this.numSplits;
    }

    public HiveInputDescription setNumSplits(int numSplits) {
        this.numSplits = numSplits;
        return this;
    }

    public void write(DataOutput out) throws IOException {
        WritableUtils.writeString((DataOutput)out, (String)this.dbName);
        WritableUtils.writeString((DataOutput)out, (String)this.tableName);
        Writables.writeStringList(out, this.columns);
        WritableUtils.writeString((DataOutput)out, (String)this.partitionFilter);
        out.writeInt(this.numSplits);
    }

    public void readFields(DataInput in) throws IOException {
        this.dbName = WritableUtils.readString((DataInput)in);
        this.tableName = WritableUtils.readString((DataInput)in);
        Writables.readStringList(in, this.columns);
        this.partitionFilter = WritableUtils.readString((DataInput)in);
        this.numSplits = in.readInt();
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("dbName", (Object)this.dbName).add("tableName", (Object)this.tableName).add("columns", this.columns).add("partitionFilter", (Object)this.partitionFilter).add("numSplits", (Object)String.valueOf(this.numSplits)).toString();
    }
}

