/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.giraph.hive.input;

import com.facebook.giraph.hive.common.HadoopUtils;
import com.facebook.giraph.hive.common.HiveMetastores;
import com.facebook.giraph.hive.common.HiveTableName;
import com.facebook.giraph.hive.common.HiveUtils;
import com.facebook.giraph.hive.common.Writables;
import com.facebook.giraph.hive.input.HInputSplit;
import com.facebook.giraph.hive.input.HiveApiInputObserver;
import com.facebook.giraph.hive.input.HiveInputDescription;
import com.facebook.giraph.hive.input.InputPartition;
import com.facebook.giraph.hive.input.RecordReaderImpl;
import com.facebook.giraph.hive.input.parser.Parsers;
import com.facebook.giraph.hive.input.parser.RecordParser;
import com.facebook.giraph.hive.record.HiveReadableRecord;
import com.facebook.giraph.hive.schema.HiveTableSchema;
import com.facebook.giraph.hive.schema.HiveTableSchemaImpl;
import com.facebook.giraph.hive.schema.HiveTableSchemas;
import com.google.common.collect.DiscreteDomains;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Range;
import com.google.common.collect.Ranges;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.api.ThriftHiveMetastore;
import org.apache.hadoop.hive.serde2.Deserializer;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.util.Progressable;
import org.apache.log4j.Logger;
import org.apache.thrift.TException;

public class HiveApiInputFormat
extends InputFormat<WritableComparable, HiveReadableRecord> {
    public static final Logger LOG = Logger.getLogger(HiveApiInputFormat.class);
    public static final String DEFAULT_PROFILE_ID = "input-profile";
    private String myProfileId = "input-profile";
    private HiveApiInputObserver observer;

    public String getMyProfileId() {
        return this.myProfileId;
    }

    public void setMyProfileId(String myProfileId) {
        this.myProfileId = myProfileId;
    }

    public HiveApiInputObserver getObserver() {
        return this.observer;
    }

    public void setObserver(HiveApiInputObserver observer) {
        this.observer = observer;
    }

    public HiveTableSchema getTableSchema(Configuration conf) {
        return HiveTableSchemas.get(conf, this.myProfileId);
    }

    private static String profileConfKey(String profileId) {
        return "hive.input." + profileId;
    }

    public static void setProfileInputDesc(Configuration conf, HiveInputDescription inputDesc, String profileId) {
        conf.set(HiveApiInputFormat.profileConfKey(profileId), Writables.writeToEncodedStr(inputDesc));
    }

    private HiveInputDescription readProfileInputDesc(HiveConf conf) {
        HiveInputDescription inputDesc = new HiveInputDescription();
        Writables.readFieldsFromEncodedStr(conf.get(HiveApiInputFormat.profileConfKey(this.myProfileId)), inputDesc);
        return inputDesc;
    }

    public List<org.apache.hadoop.mapreduce.InputSplit> getSplits(JobContext jobContext) throws IOException, InterruptedException {
        ThriftHiveMetastore.Iface client;
        LOG.info((Object)("getSplits for profile " + this.myProfileId));
        HiveConf conf = new HiveConf(jobContext.getConfiguration(), HiveApiInputFormat.class);
        try {
            client = HiveMetastores.create(conf);
        }
        catch (TException e) {
            throw new IOException(e);
        }
        return this.getSplits(conf, client);
    }

    public List<org.apache.hadoop.mapreduce.InputSplit> getSplits(HiveConf conf, ThriftHiveMetastore.Iface client) throws IOException {
        Table table;
        HiveInputDescription inputDesc = this.readProfileInputDesc(conf);
        try {
            table = client.get_table(inputDesc.getDbName(), inputDesc.getTableName());
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        HiveTableSchemaImpl tableSchema = HiveTableSchemaImpl.fromTable(table);
        HiveTableSchemas.put((Configuration)conf, this.myProfileId, tableSchema);
        List<InputPartition> partitions = this.computePartitions(inputDesc, client, table);
        List<org.apache.hadoop.mapreduce.InputSplit> splits = this.computeSplits(conf, inputDesc, tableSchema, partitions);
        return splits;
    }

    private List<org.apache.hadoop.mapreduce.InputSplit> computeSplits(HiveConf conf, HiveInputDescription inputDesc, HiveTableSchema tableSchema, List<InputPartition> partitions) throws IOException {
        int partitionNum = 0;
        ArrayList splits = Lists.newArrayList();
        int[] columnIds = this.computeColumnIds(inputDesc.getColumns(), tableSchema);
        for (InputPartition inputPartition : partitions) {
            org.apache.hadoop.mapred.InputFormat baseInputFormat = inputPartition.makeInputFormat((Configuration)conf);
            HadoopUtils.setInputDir((Configuration)conf, inputPartition.getLocation());
            InputSplit[] baseSplits = baseInputFormat.getSplits(new JobConf((Configuration)conf), inputDesc.getNumSplits());
            LOG.info((Object)("Requested " + inputDesc.getNumSplits() + " splits from partition (" + partitionNum + " out of " + Iterables.size(partitions) + ") values: " + inputPartition.getInputSplitData().getPartitionValues() + ", got " + baseSplits.length + " splits from inputFormat " + baseInputFormat.getClass()));
            for (InputSplit baseSplit : baseSplits) {
                HInputSplit split = new HInputSplit(baseInputFormat, baseSplit, tableSchema, columnIds, inputPartition.getInputSplitData(), (Configuration)conf);
                splits.add(split);
            }
            ++partitionNum;
        }
        return splits;
    }

    private int[] computeColumnIds(List<String> columnNames, HiveTableSchema tableSchema) {
        List ints;
        if (columnNames.isEmpty()) {
            Range range = Ranges.closedOpen((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(tableSchema.numColumns()));
            ints = range.asSet(DiscreteDomains.integers()).asList();
        } else {
            ints = Lists.transform(columnNames, HiveTableSchemas.schemaLookupFunc(tableSchema));
        }
        int[] result = new int[ints.size()];
        for (int i = 0; i < ints.size(); ++i) {
            result[i] = (Integer)ints.get(i);
        }
        return result;
    }

    private List<InputPartition> computePartitions(HiveInputDescription inputDesc, ThriftHiveMetastore.Iface client, Table table) throws IOException {
        ArrayList partitions = Lists.newArrayList();
        if (table.getPartitionKeysSize() == 0) {
            partitions.add(InputPartition.newFromHiveTable(table));
        } else {
            List hivePartitions;
            try {
                hivePartitions = client.get_partitions_by_filter(inputDesc.getDbName(), inputDesc.getTableName(), inputDesc.getPartitionFilter(), (short)-1);
            }
            catch (Exception e) {
                throw new IOException(e);
            }
            for (Partition hivePartition : hivePartitions) {
                partitions.add(InputPartition.newFromHivePartition(hivePartition));
            }
        }
        return partitions;
    }

    public RecordReaderImpl createRecordReader(org.apache.hadoop.mapreduce.InputSplit inputSplit, TaskAttemptContext context) throws IOException, InterruptedException {
        Configuration conf = context.getConfiguration();
        JobConf jobConf = new JobConf(conf);
        HInputSplit split = (HInputSplit)inputSplit;
        split.setConf((Configuration)jobConf);
        RecordReader<WritableComparable, Writable> baseRecordReader = split.getBaseRecordReader(jobConf, (Progressable)context);
        int[] columnIds = split.getColumnIds();
        HiveUtils.setReadColumnIds(conf, columnIds);
        RecordParser<Writable> recordParser = this.getParser((Writable)baseRecordReader.createValue(), split.getTableSchema().getTableName(), split, columnIds);
        RecordReaderImpl reader = new RecordReaderImpl(baseRecordReader, recordParser);
        reader.setObserver(this.observer);
        return reader;
    }

    private RecordParser<Writable> getParser(Writable exampleValue, HiveTableName tableName, HInputSplit split, int[] columnIds) {
        Deserializer deserializer = split.getDeserializer();
        String[] partitionValues = split.getPartitionValues();
        int numColumns = split.getTableSchema().numColumns();
        return Parsers.bestParser(deserializer, numColumns, columnIds, tableName, partitionValues, exampleValue);
    }
}

