/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.giraph.hive.common;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableUtils;

public class Writables {
    protected Writables() {
    }

    public static <T> Class<T> readClass(DataInput in) throws IOException {
        String className = WritableUtils.readString((DataInput)in);
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new IOException("Could now find class named " + className, e);
        }
    }

    public static void writeClassName(DataOutput out, Class<?> klass) throws IOException {
        WritableUtils.writeString((DataOutput)out, (String)klass.getName());
    }

    public static void writeClassName(DataOutput out, Object object) throws IOException {
        Writables.writeClassName(out, object.getClass());
    }

    public static <T> T readNewInstance(DataInput in) throws IOException {
        Class<T> klass = Writables.readClass(in);
        try {
            Constructor<T> constructor = klass.getDeclaredConstructor(new Class[0]);
            constructor.setAccessible(true);
            return constructor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new IOException("Failed to construct class " + klass.getName(), e);
        }
    }

    public static void readFieldSchemas(DataInput in, List<FieldSchema> fieldSchemas) throws IOException {
        int numColumns = in.readInt();
        fieldSchemas.clear();
        for (int i = 0; i < numColumns; ++i) {
            fieldSchemas.add(Writables.readFieldSchema(in));
        }
    }

    public static FieldSchema readFieldSchema(DataInput in) throws IOException {
        FieldSchema fs = new FieldSchema();
        fs.setName(WritableUtils.readString((DataInput)in));
        fs.setType(WritableUtils.readString((DataInput)in));
        return fs;
    }

    public static <T extends Writable> T readUnknownWritable(DataInput dataInput) throws IOException {
        Writable writable = (Writable)Writables.readNewInstance(dataInput);
        writable.readFields(dataInput);
        return (T)writable;
    }

    public static void writeUnknownWritable(DataOutput out, Writable object) throws IOException {
        Writables.writeClassName(out, object);
        object.write(out);
    }

    public static void readStrStrMap(DataInput in, Map<String, String> map) throws IOException {
        int size = in.readInt();
        map.clear();
        for (int i = 0; i < size; ++i) {
            String key = WritableUtils.readString((DataInput)in);
            String value = WritableUtils.readString((DataInput)in);
            map.put(key, value);
        }
    }

    public static void writeStrStrMap(DataOutput out, Map<String, String> map) throws IOException {
        out.writeInt(map.size());
        for (Map.Entry<String, String> entry : map.entrySet()) {
            WritableUtils.writeString((DataOutput)out, (String)entry.getKey());
            WritableUtils.writeString((DataOutput)out, (String)entry.getValue());
        }
    }

    public static void readStrIntMap(DataInput in, Map<String, Integer> data) throws IOException {
        int size = in.readInt();
        data.clear();
        for (int i = 0; i < size; ++i) {
            String key = WritableUtils.readString((DataInput)in);
            int value = in.readInt();
            data.put(key, value);
        }
    }

    public static void writeStrIntMap(DataOutput out, Map<String, Integer> map) throws IOException {
        out.writeInt(map.size());
        for (Map.Entry<String, Integer> entry : map.entrySet()) {
            WritableUtils.writeString((DataOutput)out, (String)entry.getKey());
            out.writeInt(entry.getValue());
        }
    }

    public static void writeIntArray(DataOutput out, int[] data) throws IOException {
        out.writeInt(data.length);
        for (int x : data) {
            out.writeInt(x);
        }
    }

    public static int[] readIntArray(DataInput in) throws IOException {
        int size = in.readInt();
        int[] result = new int[size];
        for (int i = 0; i < size; ++i) {
            result[i] = in.readInt();
        }
        return result;
    }

    public static void readStringList(DataInput in, List<String> data) throws IOException {
        int size = in.readInt();
        data.clear();
        for (int i = 0; i < size; ++i) {
            data.add(WritableUtils.readString((DataInput)in));
        }
    }

    public static void writeStringList(DataOutput out, List<String> data) throws IOException {
        out.writeInt(data.size());
        for (String s : data) {
            WritableUtils.writeString((DataOutput)out, (String)s);
        }
    }

    public static void writeFieldSchemas(DataOutput out, Collection<FieldSchema> fieldSchemas) throws IOException {
        out.writeInt(fieldSchemas.size());
        for (FieldSchema fs : fieldSchemas) {
            Writables.writeFieldSchema(out, fs);
        }
    }

    public static void writeFieldSchema(DataOutput out, FieldSchema fs) throws IOException {
        WritableUtils.writeString((DataOutput)out, (String)fs.getName());
        WritableUtils.writeString((DataOutput)out, (String)fs.getType());
    }

    public static void readFieldsFromByteArray(byte[] bytes, Writable writableObject) {
        DataInputStream is = new DataInputStream(new ByteArrayInputStream(bytes));
        try {
            writableObject.readFields((DataInput)is);
        }
        catch (IOException e) {
            throw new IllegalStateException("readFieldsFromByteArray: IOException", e);
        }
    }

    public static byte[] writeToByteArray(Writable writableObject) {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        DataOutputStream output = new DataOutputStream(os);
        try {
            writableObject.write((DataOutput)output);
        }
        catch (IOException e) {
            throw new IllegalStateException("writeToByteArray: IOStateException", e);
        }
        return os.toByteArray();
    }

    private static String encodeBytes(byte[] bytes) {
        StringBuilder strBuf = new StringBuilder();
        for (int i = 0; i < bytes.length; ++i) {
            strBuf.append((char)((bytes[i] >> 4 & 0xF) + 97));
            strBuf.append((char)((bytes[i] & 0xF) + 97));
        }
        return strBuf.toString();
    }

    private static byte[] decodeBytes(String str) {
        byte[] bytes = new byte[str.length() / 2];
        for (int i = 0; i < str.length(); i += 2) {
            char c = str.charAt(i);
            bytes[i / 2] = (byte)(c - 97 << 4);
            c = str.charAt(i + 1);
            int n = i / 2;
            bytes[n] = (byte)(bytes[n] + (c - 97));
        }
        return bytes;
    }

    public static String writeToEncodedStr(Writable writable) {
        return Writables.encodeBytes(Writables.writeToByteArray(writable));
    }

    public static void readFieldsFromEncodedStr(String str, Writable writable) {
        Writables.readFieldsFromByteArray(Writables.decodeBytes(str), writable);
    }
}

