/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.giraph.hive.common;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;

public class Inspectors {
    protected Inspectors() {
    }

    public static StructObjectInspector createFor(List<FieldSchema> fieldSchemas) {
        ArrayList names = Lists.newArrayList();
        ArrayList inspectors = Lists.newArrayList();
        for (FieldSchema fieldSchema : fieldSchemas) {
            names.add(fieldSchema.getName());
            inspectors.add(Inspectors.createFromFieldSchema(fieldSchema));
        }
        return ObjectInspectorFactory.getStandardStructObjectInspector((List)names, (List)inspectors);
    }

    private static ObjectInspector createFromFieldSchema(FieldSchema fieldSchema) {
        TypeInfo typeInfo = TypeInfoUtils.getTypeInfoFromTypeString((String)fieldSchema.getType());
        return TypeInfoUtils.getStandardJavaObjectInspectorFromTypeInfo((TypeInfo)typeInfo);
    }
}

