/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.giraph.hive.common;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.collect.Lists;
import com.google.common.primitives.Ints;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.Warehouse;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.serde2.ColumnProjectionUtils;
import org.apache.log4j.Logger;

public class HiveUtils {
    public static final Function<FieldSchema, String> FIELD_SCHEMA_NAME_GETTER = new Function<FieldSchema, String>(){

        public String apply(FieldSchema input) {
            return input == null ? null : input.getName();
        }
    };
    private static final Logger LOG = Logger.getLogger(HiveUtils.class);

    protected HiveUtils() {
    }

    public static List<URI> getURIs(HiveConf conf, HiveConf.ConfVars key) {
        String[] parts = conf.getVar(key).split(",");
        ArrayList uris = Lists.newArrayList();
        for (int i = 0; i < parts.length; ++i) {
            URI uri;
            try {
                uri = new URI(parts[i]);
            }
            catch (URISyntaxException e) {
                LOG.error((Object)"URI syntax error", (Throwable)e);
                continue;
            }
            if (uri.getScheme() == null) {
                LOG.error((Object)("URI '" + parts[i] + "' from key " + key + " does not have a scheme"));
                continue;
            }
            uris.add(uri);
        }
        return uris;
    }

    public static List<String> orderedPartitionValues(List<FieldSchema> partitionKeys, Map<String, String> partitionValuesMap) {
        List partitionNames = Lists.transform(partitionKeys, FIELD_SCHEMA_NAME_GETTER);
        return Lists.transform((List)partitionNames, (Function)Functions.forMap(partitionValuesMap));
    }

    public static String computePartitionPath(List<FieldSchema> partitionKeys, Map<String, String> partitionValuesMap) throws MetaException {
        List<String> values = HiveUtils.orderedPartitionValues(partitionKeys, partitionValuesMap);
        return Warehouse.makePartName(partitionKeys, values);
    }

    public static void setReadColumnIds(Configuration conf, List<Integer> columnIds) {
        if (columnIds.isEmpty()) {
            ColumnProjectionUtils.setFullyReadColumns((Configuration)conf);
        } else {
            ColumnProjectionUtils.setReadColumnIDs((Configuration)conf, columnIds);
        }
    }

    public static void setReadColumnIds(Configuration conf, int[] columnIds) {
        HiveUtils.setReadColumnIds(conf, Ints.asList((int[])columnIds));
    }

    public static void setRCileNumColumns(Configuration conf, int numColumns) {
        conf.set("hive.io.rcfile.column.number.conf", Integer.toOctalString(numColumns));
    }
}

