/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.giraph.hive.common;

import com.facebook.giraph.hive.common.NativeType;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;

public enum HiveType {
    BOOLEAN(NativeType.BOOLEAN),
    BYTE(NativeType.LONG),
    SHORT(NativeType.LONG),
    INT(NativeType.LONG),
    LONG(NativeType.LONG),
    FLOAT(NativeType.DOUBLE),
    DOUBLE(NativeType.DOUBLE),
    STRING(NativeType.STRING),
    LIST(null),
    MAP(null),
    STRUCT(null),
    UNION(null);

    private final NativeType nativeType;

    private HiveType(NativeType nativeType) {
        this.nativeType = nativeType;
    }

    public boolean isCollection() {
        return this.nativeType == null;
    }

    public boolean isPrimitive() {
        return this.nativeType != null;
    }

    public NativeType getNativeType() {
        return this.nativeType;
    }

    public static HiveType fromHiveObjectInspector(ObjectInspector objectInspector) {
        TypeInfo typeInfo = TypeInfoUtils.getTypeInfoFromObjectInspector((ObjectInspector)objectInspector);
        switch (typeInfo.getCategory()) {
            case PRIMITIVE: {
                PrimitiveObjectInspector primitiveInspector = (PrimitiveObjectInspector)objectInspector;
                return HiveType.fromHivePrimitiveCategory(primitiveInspector.getPrimitiveCategory());
            }
            case LIST: {
                return LIST;
            }
            case MAP: {
                return MAP;
            }
            case STRUCT: {
                return STRUCT;
            }
            case UNION: {
                return UNION;
            }
        }
        throw new IllegalArgumentException("Can't handle typeInfo " + typeInfo);
    }

    public static HiveType fromHivePrimitiveCategory(PrimitiveObjectInspector.PrimitiveCategory primitiveCategory) {
        switch (primitiveCategory) {
            case BOOLEAN: {
                return BOOLEAN;
            }
            case BYTE: {
                return BYTE;
            }
            case SHORT: {
                return SHORT;
            }
            case INT: {
                return INT;
            }
            case LONG: {
                return LONG;
            }
            case FLOAT: {
                return FLOAT;
            }
            case DOUBLE: {
                return DOUBLE;
            }
            case STRING: {
                return STRING;
            }
        }
        throw new IllegalArgumentException("Can't handle primitive category " + primitiveCategory);
    }
}

