/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.giraph.hive.common;

import com.facebook.giraph.hive.common.HiveUtils;
import java.lang.reflect.Field;
import java.net.URI;
import java.util.List;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.HiveMetaStoreClient;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.ThriftHiveMetastore;
import org.apache.log4j.Logger;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.transport.TSocket;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;

public class HiveMetastores {
    public static final int DEFAULT_TIMEOUT_MS = 20000;
    private static final Logger LOG = Logger.getLogger(HiveMetastores.class);

    private HiveMetastores() {
    }

    public static ThriftHiveMetastore.Iface create(String host, int port, int timeoutMillis) throws TTransportException {
        TSocket transport = new TSocket(host, port, timeoutMillis);
        transport.open();
        TBinaryProtocol protocol = new TBinaryProtocol((TTransport)transport);
        return new ThriftHiveMetastore.Client((TProtocol)protocol);
    }

    public static ThriftHiveMetastore.Iface create(String host, int port) throws TTransportException {
        return HiveMetastores.create(host, port, 20000);
    }

    public static ThriftHiveMetastore.Iface create(HiveConf hiveConf) throws TException {
        ThriftHiveMetastore.Iface client = HiveMetastores.createFromURIs(hiveConf);
        if (client == null) {
            client = HiveMetastores.createfromReflection(hiveConf);
        }
        return client;
    }

    private static ThriftHiveMetastore.Iface createfromReflection(HiveConf hiveConf) throws TException {
        ThriftHiveMetastore.Iface thriftIface;
        Field clientField;
        HiveMetaStoreClient hiveClient;
        try {
            hiveClient = new HiveMetaStoreClient(hiveConf);
        }
        catch (MetaException e) {
            throw new TException((Throwable)e);
        }
        try {
            clientField = hiveClient.getClass().getDeclaredField("client");
        }
        catch (NoSuchFieldException e) {
            throw new TException((Throwable)e);
        }
        clientField.setAccessible(true);
        try {
            thriftIface = (ThriftHiveMetastore.Iface)clientField.get(hiveClient);
        }
        catch (IllegalAccessException e) {
            throw new TException((Throwable)e);
        }
        return thriftIface;
    }

    private static ThriftHiveMetastore.Iface createFromURIs(HiveConf hiveConf) {
        List<URI> uris = HiveUtils.getURIs(hiveConf, HiveConf.ConfVars.METASTOREURIS);
        if (uris.isEmpty()) {
            LOG.warn((Object)"No Hive Metastore URIs to connect to");
            return null;
        }
        for (URI uri : uris) {
            try {
                return HiveMetastores.create(uri.getHost(), uri.getPort());
            }
            catch (TTransportException e) {
                LOG.warn((Object)("Failed to connect to " + uri.getHost() + ":" + uri.getPort()), (Throwable)e);
            }
        }
        return null;
    }
}

