/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.giraph.hive.common;

import java.io.IOException;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.output.FileOutputCommitter;
import org.apache.log4j.Logger;

public class HadoopUtils {
    private static final Logger LOG = Logger.getLogger(HadoopUtils.class);
    private static final String OUTPUT_DIR_KEY = "mapred.output.dir";

    protected HadoopUtils() {
    }

    public static void setConfIfPossible(Object object, Configuration conf) {
        if (object instanceof Configurable) {
            ((Configurable)object).setConf(conf);
        }
    }

    public static Configuration getConfIfPossible(Object object) {
        if (object instanceof Configurable) {
            return ((Configurable)object).getConf();
        }
        return null;
    }

    public static String getOutputDir(Configuration conf) {
        return conf.get(OUTPUT_DIR_KEY);
    }

    public static Path getOutputPath(Configuration conf) {
        return new Path(HadoopUtils.getOutputDir(conf));
    }

    public static void setOutputDir(Configuration conf, String path) {
        conf.set(OUTPUT_DIR_KEY, path);
    }

    public static void deleteOutputDir(Configuration conf) throws IOException {
        FileSystem.get((Configuration)conf).delete(HadoopUtils.getOutputPath(conf), true);
    }

    public static boolean needSuccessMarker(Configuration conf) {
        return conf.getBoolean("mapreduce.fileoutputcommitter.marksuccessfuljobs", false);
    }

    public static void setOutputKeyWritableClass(Configuration conf, Class<? extends Writable> writableClass) {
        conf.set("mapred.output.key.class", writableClass.getName());
    }

    public static void setOutputValueWritableClass(Configuration conf, Class<? extends Writable> writableClass) {
        conf.get("mapred.output.value.class", writableClass.getName());
    }

    public static void setWorkOutputDir(TaskAttemptContext context) throws IOException {
        Configuration conf = context.getConfiguration();
        String outputPath = HadoopUtils.getOutputDir(conf);
        if (outputPath != null) {
            FileOutputCommitter foc = new FileOutputCommitter(HadoopUtils.getOutputPath(conf), context);
            conf.set("mapred.work.output.dir", foc.getWorkPath().toString());
        }
    }

    public static void setInputDir(Configuration conf, String path) {
        conf.set("mapred.input.dir", path);
    }
}

