/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.giraph.hive.common;

import java.io.IOException;
import java.net.URI;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;

public class FileSystems {
    public static final PathFilter HIDDEN_FILTER = new PathFilter(){

        public boolean accept(Path path) {
            String name = path.getName();
            return !name.startsWith("_") && !name.startsWith(".");
        }
    };

    protected FileSystems() {
    }

    public static FileStatus[] listNonHidden(FileSystem fs, Path dir) throws IOException {
        return fs.globStatus(new Path(dir, "*"), HIDDEN_FILTER);
    }

    public static boolean dirHasNonHiddenFiles(FileSystem fs, Path dir) throws IOException {
        return FileSystems.listNonHidden(fs, dir).length != 0;
    }

    public static Path pathInDestination(Path file, Path srcDir, Path destDir) {
        URI fileUri = file.toUri();
        URI relativeUri = srcDir.toUri().relativize(fileUri);
        if (relativeUri == fileUri) {
            throw new IllegalArgumentException("Could not get file " + file + " relative path in " + srcDir);
        }
        String relativePath = relativeUri.getPath();
        if (relativePath.isEmpty()) {
            return destDir;
        }
        return new Path(destDir, relativePath);
    }

    public static void move(FileSystem fs, Path file, Path src, Path dest) throws IOException {
        Path destFilePath = FileSystems.pathInDestination(file, src, dest);
        if (fs.isFile(file)) {
            if (fs.exists(destFilePath)) {
                if (!fs.delete(destFilePath, true)) {
                    throw new IllegalArgumentException("Could not remove existing file " + destFilePath);
                }
                if (!fs.rename(file, destFilePath)) {
                    throw new IllegalArgumentException("Could not move " + file + " to " + destFilePath);
                }
            }
        } else if (fs.getFileStatus(file).isDir()) {
            FileStatus[] statuses = fs.listStatus(file);
            fs.mkdirs(destFilePath);
            if (statuses != null) {
                for (FileStatus status : statuses) {
                    FileSystems.move(fs, status.getPath(), src, dest);
                }
            }
        }
    }
}

